/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.Builder;
import net.sourceforge.texlipse.builder.BuilderRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class BuilderChooser {
    private Group formatGroup;
    private Combo formatChooser;
    private Combo sequenceChooser;
    private String[][] mapping;
    private HashMap<String, Integer> idMap;
    private ArrayList<SelectionListener> selectionListeners = new ArrayList();

    public BuilderChooser(Composite parent) {
        this.createMappings();
        this.formatGroup = new Group(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 4;
        this.formatGroup.setLayout((Layout)gl);
        this.formatGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)this.formatGroup, 16384);
        label.setText(TexlipsePlugin.getResourceString("propertiesOutputFormatLabel"));
        label.setLayoutData((Object)new GridData());
        this.formatChooser = new Combo((Composite)this.formatGroup, 12);
        this.formatChooser.setLayoutData((Object)new GridData());
        this.formatChooser.setToolTipText(TexlipsePlugin.getResourceString("propertiesOutputFormatTooltip"));
        this.formatChooser.setItems(new String[]{"dvi", "ps", "pdf"});
        this.formatChooser.select(0);
        this.formatChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = BuilderChooser.this.formatChooser.getSelectionIndex();
                if (index >= 0) {
                    BuilderChooser.this.sequenceChooser.setItems(BuilderChooser.this.mapping[index]);
                    BuilderChooser.this.sequenceChooser.select(0);
                    BuilderChooser.this.fireSelectionEvent(event);
                }
            }
        });
        Label slabel = new Label((Composite)this.formatGroup, 16384);
        slabel.setText(TexlipsePlugin.getResourceString("propertiesOutputSequenceLabel"));
        slabel.setLayoutData((Object)new GridData());
        this.sequenceChooser = new Combo((Composite)this.formatGroup, 12);
        this.sequenceChooser.setLayoutData((Object)new GridData(768));
        this.sequenceChooser.setToolTipText(TexlipsePlugin.getResourceString("propertiesOutputSequenceTooltip"));
        this.sequenceChooser.setItems(this.mapping[0]);
        this.sequenceChooser.select(0);
        this.sequenceChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = BuilderChooser.this.sequenceChooser.getSelectionIndex();
                if (index >= 0) {
                    BuilderChooser.this.fireSelectionEvent(event);
                }
            }
        });
        Link prefLink = new Link((Composite)this.formatGroup, 0);
        prefLink.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        prefLink.setText(TexlipsePlugin.getResourceString("propertiesOutputLinkToPrefs"));
        prefLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)BuilderChooser.this.formatGroup.getShell(), (String)"TexlipseBuilderPreferencePage", (String[])new String[]{"TexlipseBuilderPreferencePage", "net.sourceforge.texlipse.properties.BuilderEnvPreferencePage"}, null).open();
            }
        });
    }

    private void createMappings() {
        this.idMap = new HashMap();
        Builder[] dvis = BuilderRegistry.getAll("dvi");
        Builder[] pses = BuilderRegistry.getAll("ps");
        Builder[] pdfs = BuilderRegistry.getAll("pdf");
        this.mapping = new String[3][];
        this.mapping[0] = new String[dvis.length];
        int i = 0;
        while (i < dvis.length) {
            this.mapping[0][i] = dvis[i].getSequence();
            this.idMap.put(this.mapping[0][i], new Integer(dvis[i].getId()));
            ++i;
        }
        this.mapping[1] = new String[pses.length];
        i = 0;
        while (i < pses.length) {
            this.mapping[1][i] = pses[i].getSequence();
            this.idMap.put(this.mapping[1][i], new Integer(pses[i].getId()));
            ++i;
        }
        this.mapping[2] = new String[pdfs.length];
        i = 0;
        while (i < pdfs.length) {
            this.mapping[2][i] = pdfs[i].getSequence();
            this.idMap.put(this.mapping[2][i], new Integer(pdfs[i].getId()));
            ++i;
        }
    }

    private void fireSelectionEvent(SelectionEvent event) {
        int i = 0;
        while (i < this.selectionListeners.size()) {
            SelectionListener lis = this.selectionListeners.get(i);
            lis.widgetSelected(event);
            ++i;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public String getSelectedFormat() {
        int index = this.formatChooser.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        return this.formatChooser.getItem(index);
    }

    public int getSelectedBuilder() {
        int index = this.sequenceChooser.getSelectionIndex();
        if (index >= 0) {
            String seq = this.sequenceChooser.getItem(index);
            Integer num = this.idMap.get(seq);
            index = -1;
            if (num != null) {
                index = num;
            }
        }
        return index;
    }

    public void setSelectedBuilder(int num) {
        Builder b = BuilderRegistry.get(num);
        if (b != null) {
            String sequence = b.getSequence();
            int index = this.formatChooser.indexOf(b.getOutputFormat());
            if (index < 0) {
                index = 0;
            }
            this.formatChooser.select(index);
            this.sequenceChooser.setItems(this.mapping[index]);
            index = this.sequenceChooser.indexOf(sequence);
            if (index < 0) {
                index = 0;
            }
            this.sequenceChooser.select(index);
        }
    }

    public Composite getControl() {
        return this.formatGroup;
    }
}

