/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.PDFString;
import java.io.IOException;
import java.io.Writer;

public class PDFTextString
extends PDFString {
    String val;
    static final char OPENING_QUOTE = '(';
    static final char CLOSING_QUOTE = ')';
    static final char ESC_CHAR = '\\';

    public PDFTextString(String init) {
        this.val = init;
    }

    PDFTextString(String init, Object flag) {
        this(init);
    }

    public boolean equals(Object obj) {
        return obj instanceof PDFTextString && this.val.equals(((PDFTextString)obj).val);
    }

    public int hashCode() {
        return this.val.hashCode();
    }

    public String toString() {
        return this.val;
    }

    public void write(Writer out) throws IOException {
        out.write(40);
        int i = 0;
        while (i < this.val.length()) {
            char c = this.val.charAt(i);
            if (c < ' ' || c > '\u007f') {
                switch (c) {
                    case '\t': {
                        out.write("\\t");
                        break;
                    }
                    case '\n': {
                        out.write("\\n");
                        break;
                    }
                    default: {
                        out.write(92);
                        out.write(Character.forDigit(c / 64, 8));
                        out.write(Character.forDigit(c / 8 % 8, 8));
                        out.write(Character.forDigit(c % 8, 8));
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        out.write(92);
                        break;
                    }
                }
                out.write(c);
            }
            ++i;
        }
        out.write(41);
    }
}

