/*
* Turn \n\n*[non\] into \par.
*/
#include <stdio.h>
#include <ctype.h>

int main(int argc, char *argv[])
{
  int c;
  int nl = 0;  /* newline count */
  int ws = 0;  /* whitespace count */

  while ((c = getchar()) != EOF) {
    /* if newline or white space just after newline */
    if (c == '\n') {
      nl++;
      ws = 0;
    }
    else if (nl > 0 && isspace(c)) {
      ws++;
    }
    else if (nl > 1) {
      if (c != '\\') puts("\n\\par");
      else putchar('\n');
      for (; ws > 0; ws--) putchar(' ');
      putchar(c); 
      nl = 0;
    }
    else if (nl == 1) {
      putchar('\n');
      for (; ws > 0; ws--) putchar(' ');
      putchar(c);
      nl = 0;
    }
    else {
      for (; ws > 0; ws--) putchar(' ');
      putchar(c); 
    }
  }
  if (nl > 0) putchar('\n');
}
