/* SIMPLE - Simple Is a Macro Processing Language Element */
/* Copyright (c) 1998 David A. Madore (david.madore@ens.fr) */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Miscellaneous routines.
 */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

#include "simple.h"

void
fatal(char internal,char *fmt, ...)
     /* Terminate on error. */
{
  va_list ap;
  va_start(ap,fmt);
  if (internal) fprintf(stderr,"INTERNAL ERROR: ");
  else fprintf(stderr,"Error: ");
#if defined(HAVE_VPRINTF)
  vfprintf(stderr,fmt,ap);
#else
  fprintf(stderr,"%s",fmt); /* That's the best I thought of... */
#endif
  fprintf(stderr,"\n");
  va_end(ap);
  exit(EXIT_FAILURE);
}

#if !defined(HAVE_GOOD_ALLOC)
void
safe_free(void *ptr)
{
  if (ptr==NULL) return;
  free(ptr);
}

void *
safe_realloc(void *ptr,size_t size)
{
  if (ptr==NULL) return malloc(size);
  if (size==0) {
    safe_free(ptr);
    return NULL;
  }
  return realloc(ptr,size);
}
#endif
