#!/usr/bin/env texlua

--[[
    mol2chemfig.lua by Michael Palmer, University of Waterloo
    -------------------------------------------------------------------------
    Purpose: Generation of chemfig code from molecular structures specified
    in molfile or smiles format

    Licence: LPPL (free)
    -------------------------------------------------------------------------
    This script acts as a thin client; it passes off all work to a server
    installation of the mol2chemfig program. Therefore, you need to be
    online for this program to work.

    The server is accessed using the IP address instead of the URL, which
    saves a DNS lookup. However, if things don't work, the IP might have
    changed. In that case, you might try this URL:

    server_address = "http://chimpsky.uwaterloo.ca/mol2chemfig/luabackend"

    The "kpse.set_program_name('luatex')" call causes the use of kpathsea to
    locate imported modules. The mol2chemfig-client.lua module should then be
    found if installed along the LUAINPUTS path that is set in your texmf.cnf
    configuration file.
    -------------------------------------------------------------------------
    send bug reports and lots of money to mpalmer@uwaterloo.ca
]]--

server_address = "http://129.97.80.65/mol2chemfig/luabackend"

kpse.set_program_name('luatex')

require('mol2chemfig_client.lua')
