/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdr.JDRBitmap;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.NonNegativeDoublePanel;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.NonNegativeIntPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.ScanImage;

public class VectorizeBitmapDialog
extends JDialog
implements ActionListener {
    private JpgfDraw application_;
    private JDRFrame mainPanel;
    private JDRBitmap bitmap;
    private Color base;
    private JDialog colorChooserDialog;
    private JColorChooser colorChooser;
    private NonNegativeIntPanel xIncPanel;
    private NonNegativeIntPanel yIncPanel;
    private NonNegativeDoublePanel tolerance;
    private JCheckBox straightenBox;
    private JCheckBox smoothBox;
    private NonNegativeDoublePanel chi;
    private NonNegativeDoublePanel delta;
    private NonNegativeDoublePanel gamma;
    private NonNegativeDoublePanel rho;
    private NonNegativeDoublePanel sigma;
    private NonNegativeDoublePanel smoothTolFun;
    private NonNegativeDoublePanel smoothTol;
    private NonNegativeDoublePanel flatness;
    private NonNegativeIntPanel maxIter;
    private NonNegativeIntPanel maxFunEvals;
    private Component swatch;

    public VectorizeBitmapDialog(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("vectorize.title"), true);
        this.application_ = jpgfDraw;
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel();
        this.xIncPanel = new NonNegativeIntPanel("vectorize.xinc", 2);
        this.xIncPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.xIncPanel);
        this.yIncPanel = new NonNegativeIntPanel("vectorize.yinc", 2);
        this.yIncPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.yIncPanel);
        box.add(jPanel);
        Box box2 = Box.createVerticalBox();
        box2.setBorder(BorderFactory.createEtchedBorder());
        this.straightenBox = new JCheckBox(JDRResources.getString("vectorize.straighten"), false);
        this.straightenBox.addActionListener(this);
        this.straightenBox.setActionCommand("straighten");
        box2.add(this.straightenBox);
        this.tolerance = new NonNegativeDoublePanel("vectorize.tolerance", 1.0);
        box2.add(this.tolerance);
        box.add(box2);
        Box box3 = Box.createVerticalBox();
        box3.setBorder(BorderFactory.createEtchedBorder());
        this.smoothBox = new JCheckBox(JDRResources.getString("vectorize.smooth"), true);
        this.smoothBox.addActionListener(this);
        this.smoothBox.setActionCommand("smooth");
        box3.add(this.smoothBox);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(5, 2));
        this.chi = new NonNegativeDoublePanel("vectorize.chi", 2.0);
        jPanel2.add(this.chi);
        this.delta = new NonNegativeDoublePanel("vectorize.delta", 0.01);
        jPanel2.add(this.delta);
        this.gamma = new NonNegativeDoublePanel("vectorize.gamma", 0.5);
        jPanel2.add(this.gamma);
        this.rho = new NonNegativeDoublePanel("vectorize.rho", 1.0);
        jPanel2.add(this.rho);
        this.sigma = new NonNegativeDoublePanel("vectorize.sigma", 0.5);
        jPanel2.add(this.sigma);
        this.smoothTolFun = new NonNegativeDoublePanel("vectorize.smoothTolFun", 1.0E-6);
        jPanel2.add(this.smoothTolFun);
        this.smoothTol = new NonNegativeDoublePanel("vectorize.smoothTol", 1.0E-6);
        jPanel2.add(this.smoothTol);
        this.maxIter = new NonNegativeIntPanel("vectorize.maxIter", 200);
        jPanel2.add(this.maxIter);
        this.maxFunEvals = new NonNegativeIntPanel("vectorize.maxFunEvals", 1000);
        jPanel2.add(this.maxFunEvals);
        this.flatness = new NonNegativeDoublePanel("vectorize.flatness", 1.0);
        jPanel2.add(this.flatness);
        box3.add(jPanel2);
        box.add(box3);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel(JDRResources.getString("vectorize.base")));
        this.base = Color.black;
        this.swatch = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(40, 20);
            }

            @Override
            public Color getBackground() {
                return VectorizeBitmapDialog.this.base;
            }
        };
        jPanel3.add(this.swatch);
        JButton jButton = new JButton(JDRResources.getString("vectorize.selectbase"));
        jButton.setMnemonic(JDRResources.getChar("vectorize.selectbase.mnemonic"));
        jButton.addActionListener(this);
        jButton.setActionCommand("selectBase");
        jPanel3.add(jButton);
        box.add(jPanel3);
        this.colorChooser = new JColorChooser(this.swatch.getBackground());
        this.colorChooserDialog = JColorChooser.createDialog(jpgfDraw, JDRResources.getString("vectorize.selectbase.title"), true, this.colorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VectorizeBitmapDialog.this.base = VectorizeBitmapDialog.this.colorChooser.getColor();
                VectorizeBitmapDialog.this.swatch.repaint();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.getContentPane().add((Component)box, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.add(JDRResources.createOkayButton(this));
        jPanel4.add(JDRResources.createCancelButton(this));
        this.getContentPane().add((Component)jPanel4, "South");
        this.pack();
        this.setLocationRelativeTo(jpgfDraw);
    }

    public void display() {
        this.mainPanel = this.application_.getCurrentFrame();
        this.bitmap = this.mainPanel.getSelectedBitmap();
        this.setVisible(true);
    }

    private void setStraighten(boolean bl) {
        if (this.straightenBox.isSelected() != bl) {
            this.straightenBox.setSelected(bl);
        }
        this.tolerance.setEnabled(bl);
    }

    private void setSmooth(boolean bl) {
        if (this.smoothBox.isSelected() != bl) {
            this.smoothBox.setSelected(bl);
        }
        this.chi.setEnabled(bl);
        this.delta.setEnabled(bl);
        this.gamma.setEnabled(bl);
        this.rho.setEnabled(bl);
        this.sigma.setEnabled(bl);
        this.smoothTolFun.setEnabled(bl);
        this.smoothTol.setEnabled(bl);
        this.maxIter.setEnabled(bl);
        this.maxFunEvals.setEnabled(bl);
        this.flatness.setEnabled(bl);
    }

    public int getXInc() {
        return this.xIncPanel.getValue();
    }

    public int getYInc() {
        return this.yIncPanel.getValue();
    }

    public Color getBase() {
        return this.base;
    }

    public double getStraightenTolerance() {
        return this.tolerance.getValue();
    }

    public double getChi() {
        return this.chi.getValue();
    }

    public double getDelta() {
        return this.delta.getValue();
    }

    public double getGamma() {
        return this.gamma.getValue();
    }

    public double getRho() {
        return this.rho.getValue();
    }

    public double getSigma() {
        return this.sigma.getValue();
    }

    public double getSmoothTolFun() {
        return this.smoothTolFun.getValue();
    }

    public double getSmoothTol() {
        return this.smoothTol.getValue();
    }

    public int getMaxIter() {
        return this.maxIter.getValue();
    }

    public int getMaxFunEvals() {
        return this.maxFunEvals.getValue();
    }

    public double getFlatness() {
        return this.flatness.getValue();
    }

    public boolean isStraightenSelected() {
        return this.straightenBox.isSelected();
    }

    public boolean isSmoothSelected() {
        return this.smoothBox.isSelected();
    }

    public void okay() {
        ScanImage scanImage = new ScanImage(this.mainPanel, this.bitmap, this);
        scanImage.performScan();
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("okay")) {
            this.okay();
        } else if (string.equals("cancel")) {
            this.setVisible(false);
        } else if (string.equals("selectBase")) {
            this.colorChooserDialog.setVisible(true);
        } else if (string.equals("straighten")) {
            this.setStraighten(this.straightenBox.isSelected());
        } else if (string.equals("smooth")) {
            this.setSmooth(this.smoothBox.isSelected());
        }
    }
}

