/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.HexField;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.TextFieldSampleListener;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.CharacterSelector;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.SampleCharPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.SymbolSelectorListener;

public class UnicodePanel
extends JPanel
implements ActionListener {
    private SymbolSelectorListener listener;
    private CharacterSelector selector;
    private HexField unicodeField;
    private JButton selectButton;
    private SampleCharPanel samplePanel;

    public UnicodePanel(SymbolSelectorListener symbolSelectorListener, CharacterSelector characterSelector) {
        super(new BorderLayout());
        this.listener = symbolSelectorListener;
        this.selector = characterSelector;
        this.samplePanel = new SampleCharPanel(this);
        this.add((Component)this.samplePanel, "Center");
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(JDRResources.getString("symbol.unicode"));
        jLabel.setDisplayedMnemonic(JDRResources.getChar("symbol.unicode.mnemonic"));
        jPanel.add(jLabel);
        this.unicodeField = new HexField(0);
        this.unicodeField.setToolTipText(JDRResources.getString("tooltip.unicode_value"));
        this.unicodeField.getDocument().addDocumentListener(new TextFieldSampleListener(this.samplePanel));
        jLabel.setLabelFor(this.unicodeField);
        jPanel.add(this.unicodeField);
        this.selectButton = new JButton(JDRResources.getString("symbol.select"));
        this.selectButton.setMnemonic(JDRResources.getChar("symbol.select.mnemonic"));
        this.selectButton.addActionListener(this);
        this.selectButton.setActionCommand("selectsymbol");
        this.selectButton.setToolTipText(JDRResources.getString("tooltip.unicode_select"));
        jPanel.add(this.selectButton);
        this.add((Component)jPanel, "North");
    }

    public boolean unicodeFieldHasFocus() {
        return this.unicodeField.hasFocus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("selectsymbol")) {
            this.selector.insertChar(this.getSymbol());
        }
    }

    public void setSymbol(int n) {
        this.unicodeField.setValue(n);
    }

    public void setHexString(String string) {
        this.unicodeField.setText(string);
    }

    public char getSymbol() {
        return (char)this.unicodeField.getValue();
    }

    public SymbolSelectorListener getSymbolSelectorListener() {
        return this.listener;
    }

    public RenderingHints getSymbolRenderingHints() {
        return this.listener.getRenderingHints();
    }

    public Font getSymbolFont() {
        return this.listener.getSymbolButtonFont();
    }
}

