/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.CharacterSelector;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.SymbolSelectorListener;

public class TextSelector
extends JDialog
implements ActionListener,
SymbolSelectorListener {
    private JpgfDraw application_;
    private JTextField textbox;
    private JTextField latexbox;
    private CharacterSelector symbolSelector;
    private JPopupMenu textpopupMenu;
    private JRadioButton same;
    private JRadioButton different;
    private Font buttonFont = null;
    private JMenuItem copyText;
    private JMenuItem cutText;

    public TextSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("edittext.title"), true);
        this.application_ = jpgfDraw;
        this.setLocationRelativeTo(this.application_);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1));
        this.textbox = new JTextField(){

            @Override
            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                RenderingHints renderingHints = TextSelector.this.getRenderingHints();
                if (renderingHints != null) {
                    RenderingHints renderingHints2 = graphics2D.getRenderingHints();
                    graphics2D.setRenderingHints(renderingHints);
                    super.paintComponent(graphics);
                    graphics2D.setRenderingHints(renderingHints2);
                }
            }
        };
        this.symbolSelector = new CharacterSelector((Dialog)this, (SymbolSelectorListener)this);
        this.textpopupMenu = new JPopupMenu();
        this.copyText = new JMenuItem(JDRResources.getString("edit.copy"), JDRResources.getChar("edit.copy.mnemonic"));
        this.textpopupMenu.add(this.copyText);
        this.copyText.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSelector.this.textbox.copy();
            }
        });
        this.cutText = new JMenuItem(JDRResources.getString("edit.cut"), JDRResources.getChar("edit.cut.mnemonic"));
        this.textpopupMenu.add(this.cutText);
        this.cutText.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSelector.this.textbox.cut();
            }
        });
        JMenuItem jMenuItem = new JMenuItem(JDRResources.getString("edit.paste"), JDRResources.getChar("edit.paste.mnemonic"));
        this.textpopupMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSelector.this.textbox.paste();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(JDRResources.getString("edit.select_all"), JDRResources.getChar("edit.select_all.mnemonic"));
        this.textpopupMenu.add(jMenuItem2);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSelector.this.textbox.selectAll();
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(JDRResources.getString("text.insert_symbol"), JDRResources.getChar("text.insert_symbol.mnemonic"));
        this.textpopupMenu.add(jMenuItem3);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(155, 0));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSelector.this.symbolSelector.display();
            }
        });
        this.textbox.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.checkForPopupTrigger(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.checkForPopupTrigger(mouseEvent);
            }

            private void checkForPopupTrigger(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TextSelector.this.showPopUp(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.textbox.registerKeyboardAction(this, "insert", KeyStroke.getKeyStroke(155, 0), 0);
        this.textbox.registerKeyboardAction(this, "popup", KeyStroke.getKeyStroke(114, 0), 0);
        jPanel.add(this.textbox);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel(JDRResources.getString("edittext.latexlabel")));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.same = new JRadioButton(JDRResources.getString("edittext.same"), true);
        this.same.setMnemonic(JDRResources.getChar("edittext.same.mnemonic"));
        buttonGroup.add(this.same);
        jPanel2.add(this.same);
        this.same.setActionCommand("same");
        this.same.addActionListener(this);
        this.different = new JRadioButton(JDRResources.getString("edittext.different"), false);
        this.different.setMnemonic(JDRResources.getChar("edittext.different.mnemonic"));
        buttonGroup.add(this.different);
        jPanel2.add(this.different);
        this.different.addActionListener(this);
        this.different.setActionCommand("different");
        jPanel.add(jPanel2);
        this.latexbox = new JTextField();
        jPanel.add(this.latexbox);
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(JDRResources.createOkayButton(this));
        jPanel3.add(JDRResources.createCancelButton(this));
        jPanel3.add(JDRResources.createHelpButton("sec:edittext"));
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
    }

    public void display() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        JDRTextual jDRTextual = jDRFrame.getSelectedText();
        if (jDRTextual == null) {
            JDRResources.internalError(JDRResources.getString("internal_error.cant_find_selected_text"));
            return;
        }
        this.textbox.setText(jDRTextual.getText());
        this.textbox.requestFocusInWindow();
        this.latexbox.setText(jDRTextual.getLaTeXText());
        if (jDRTextual.getText().equals(jDRTextual.getLaTeXText())) {
            this.same.setSelected(true);
            this.latexbox.setEnabled(false);
        } else {
            this.different.setSelected(true);
            this.latexbox.setEnabled(true);
        }
        this.buttonFont = jDRFrame.getSymbolButtonFont();
        this.textbox.setFont(this.buttonFont);
        this.setVisible(true);
    }

    @Override
    public void setText(String string) {
        this.textbox.setText(string);
        this.textbox.requestFocusInWindow();
    }

    @Override
    public Font getSymbolFont() {
        return this.textbox.getFont();
    }

    @Override
    public String getSymbolText() {
        return this.textbox.getText();
    }

    @Override
    public Font getSymbolButtonFont() {
        return this.buttonFont;
    }

    @Override
    public int getSymbolCaretPosition() {
        return this.textbox.getCaretPosition();
    }

    @Override
    public void setSymbolCaretPosition(int n) {
        this.textbox.setCaretPosition(n);
    }

    @Override
    public void requestSymbolFocus() {
        this.textbox.requestFocusInWindow();
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.application_.getRenderingHints();
    }

    public void okay() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        if (this.same.isSelected()) {
            jDRFrame.setSelectedText(this.textbox.getText());
        } else {
            jDRFrame.setSelectedText(this.textbox.getText(), this.latexbox.getText());
        }
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("okay")) {
            this.okay();
        } else if (string.equals("cancel")) {
            this.setVisible(false);
        } else if (string.equals("same")) {
            this.latexbox.setText(this.textbox.getText());
            this.latexbox.setEnabled(false);
            this.textbox.requestFocusInWindow();
        } else if (string.equals("different")) {
            this.latexbox.setEnabled(true);
            this.latexbox.requestFocusInWindow();
        } else if (string.equals("insert")) {
            this.symbolSelector.display();
        } else if (string.equals("popup")) {
            Point point = this.textbox.getCaret().getMagicCaretPosition();
            this.showPopUp(point.x, point.y);
        }
    }

    public void showPopUp(int n, int n2) {
        String string = this.textbox.getSelectedText();
        this.copyText.setEnabled(string != null);
        this.cutText.setEnabled(string != null);
        this.textpopupMenu.show(this.textbox, n, n2);
    }

    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = string2 + "TextSelector:" + string;
        string2 = string2 + "has focus: " + this.hasFocus() + string;
        string2 = string2 + "text box has focus: " + this.textbox.hasFocus() + string;
        string2 = string2 + "LaTeX box has focus: " + this.latexbox.hasFocus() + string;
        ActionMap actionMap = this.getRootPane().getActionMap();
        string2 = string2 + "action map: " + string;
        Object[] objectArray = actionMap.allKeys();
        for (int i = 0; i < objectArray.length; ++i) {
            string2 = string2 + "Key: " + objectArray[i] + " Action: " + actionMap.get(objectArray[i]) + string;
        }
        return string2 + string;
    }
}

