/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.PaintPanel;

public class TextPaintSelector
extends JDRSelector {
    private PaintPanel paintPanel;
    private JDRTextual textArea = null;

    public TextPaintSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("textcolour.title"), false, true);
        JpgfDraw.enableHelpOnButton(this.help, "sec:textcolour");
        this.paintPanel = new PaintPanel(this);
        this.paintPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setToMain(this.paintPanel);
        Dimension dimension = this.getSize();
        int n = dimension.width;
        this.pack();
        dimension = this.getSize();
        dimension.width = n;
        this.setSize(dimension);
        this.setLocationRelativeTo(jpgfDraw);
    }

    @Override
    public String getSampleText() {
        if (this.textArea != null && !this.textArea.getText().equals("")) {
            return this.textArea.getText();
        }
        return super.getSampleText();
    }

    @Override
    public JDRPaint getTextPaint() {
        return this.paintPanel.getPaint();
    }

    @Override
    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        this.textArea = jDRFrame.getSelectedText();
        this.paintPanel.setPaint(jDRFrame.getSelectedTextPaint());
        super.initialise();
    }

    @Override
    public void okay() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        jDRFrame.setSelectedTextPaint(this.getTextPaint());
        super.okay();
    }

    @Override
    public void setDefaults() {
        this.paintPanel.setPaint(new JDRColor(Color.black));
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = "LinePaintSelector:" + string;
        return string2 + super.info();
    }
}

