/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;

public class TeXSettingsPanel
extends Box
implements ItemListener {
    private JComboBox sizeBox;
    private JLabel example;
    private static final Integer[] availableSizes = new Integer[]{new Integer(25), new Integer(20), new Integer(17), new Integer(14), new Integer(12), new Integer(11), new Integer(10), new Integer(9), new Integer(8)};
    private JCheckBox updateImageBox;

    public TeXSettingsPanel() {
        super(1);
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        this.add(box);
        JLabel jLabel = new JLabel(JDRResources.getString("texsettings.label"));
        jLabel.setDisplayedMnemonic(JDRResources.getChar("texsettings.label.mnemonic"));
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(10));
        this.sizeBox = new JComboBox<Integer>(availableSizes);
        this.sizeBox.addItemListener(this);
        jLabel.setLabelFor(this.sizeBox);
        box.add(this.sizeBox);
        this.sizeBox.setAlignmentX(0.0f);
        box.add(Box.createHorizontalGlue());
        this.add(Box.createVerticalStrut(10));
        this.updateImageBox = new JCheckBox(JDRResources.getString("texsettings.update"), true);
        this.updateImageBox.setMnemonic(JDRResources.getChar("texsettings.update.mnemonic"));
        this.updateImageBox.setSelected(JpgfDraw.isLaTeXFontUpdateEnabled());
        this.updateImageBox.setAlignmentX(0.0f);
        this.add(this.updateImageBox);
        this.add(Box.createVerticalStrut(10));
        JTextArea jTextArea = new JTextArea(JDRResources.getString("texsettings.note"));
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setAlignmentX(0.0f);
        this.add(jTextArea);
        this.add(Box.createVerticalStrut(10));
        this.example = new JLabel("\\documentclass[10pt]{article}");
        this.example.setAlignmentX(0.0f);
        this.add(this.example);
    }

    public void initialise(JDRFrame jDRFrame) {
        int n = jDRFrame.getNormalSize();
        for (int i = 0; i < availableSizes.length; ++i) {
            if (availableSizes[i] != n) continue;
            this.sizeBox.setSelectedIndex(i);
            break;
        }
        this.updateExample(n);
    }

    public void updateExample(int n) {
        if (n >= 10 && n <= 12) {
            this.example.setText("\\documentclass[" + n + "pt]{article}");
        } else if (n >= 24) {
            this.example.setText("\\documentclass{a0poster}");
        } else {
            this.example.setText("\\documentclass[" + n + "pt]{extarticle}");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = (Integer)this.sizeBox.getSelectedItem();
        this.updateExample(n);
    }

    public void okay(JDRFrame jDRFrame) {
        int n = (Integer)this.sizeBox.getSelectedItem();
        jDRFrame.setNormalSize(n);
        if (this.updateImageBox.isSelected()) {
            jDRFrame.updateLaTeXFontSize();
        }
        JpgfDraw.setLaTeXFontUpdate(this.getLaTeXFontUpdate());
    }

    public boolean getLaTeXFontUpdate() {
        return this.updateImageBox.isSelected();
    }

    public void setLaTeXFontUpdate(boolean bl) {
        this.updateImageBox.setSelected(bl);
    }
}

