/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparent;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.FontPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.LineStylePanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.PaintPanel;

public class StyleSelector
extends JDRSelector {
    private PaintPanel linePanel;
    private PaintPanel fillPanel;
    private PaintPanel textPanel;
    private LineStylePanel linestylePanel;
    private FontPanel fontPanel;
    private JTabbedPane tabbedPane;

    public StyleSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("styles.title"), true, true, true);
        JpgfDraw.enableHelpOnButton(this.help, "sec:styles");
        this.tabbedPane = new JTabbedPane();
        this.setToMain(this.tabbedPane);
        this.linePanel = new PaintPanel(this);
        this.tabbedPane.addTab(JDRResources.getString("linecolour.label"), null, this.linePanel, JDRResources.getString("tooltip.line_colour"));
        this.linePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tabbedPane.setMnemonicAt(0, JDRResources.getChar("linecolour.mnemonic"));
        this.fillPanel = new PaintPanel(this);
        this.tabbedPane.addTab(JDRResources.getString("fillcolour.label"), null, this.fillPanel, JDRResources.getString("tooltip.fill_colour"));
        this.fillPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tabbedPane.setMnemonicAt(1, JDRResources.getChar("fillcolour.mnemonic"));
        this.linestylePanel = new LineStylePanel(this);
        this.tabbedPane.addTab(JDRResources.getString("linestyle.label"), null, this.linestylePanel, JDRResources.getString("tooltip.line_style"));
        this.linestylePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tabbedPane.setMnemonicAt(2, JDRResources.getChar("linestyle.mnemonic"));
        this.textPanel = new PaintPanel(this);
        this.tabbedPane.addTab(JDRResources.getString("textcolour.label"), null, this.textPanel, JDRResources.getString("tooltip.text_colour"));
        this.textPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tabbedPane.setMnemonicAt(3, JDRResources.getChar("textcolour.mnemonic"));
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        this.fontPanel = new FontPanel(this, this.application_.getFontFamilies());
        this.tabbedPane.addTab(JDRResources.getString("font.label"), null, this.fontPanel, JDRResources.getString("tooltip.font"));
        this.fontPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tabbedPane.setMnemonicAt(4, JDRResources.getChar("font.mnemonic"));
        this.setDefaults();
        this.pack();
        Dimension dimension = this.getSize();
        dimension.height = 600;
        this.setSize(dimension);
        this.setLocationRelativeTo(this.application_);
    }

    public void display() {
        this.fontPanel.setLaTeXFonts(this.application_.getCurrentLaTeXFontBase());
        this.setLinePaint(this.application_.getCurrentLinePaint());
        this.setFillPaint(this.application_.getCurrentFillPaint());
        this.setTextPaint(this.application_.getCurrentTextPaint());
        this.setStroke(this.application_.getCurrentStroke());
        this.setFontName(this.application_.getCurrentFontFamily());
        this.setFontSize(this.application_.getCurrentFontSize());
        this.setFontShape(this.application_.getCurrentFontShape());
        this.setFontSeries(this.application_.getCurrentFontSeries());
        this.setLaTeXFontFamily(this.application_.getCurrentLaTeXFontFamily());
        this.setLaTeXFontSeries(this.application_.getCurrentLaTeXFontSeries());
        this.setLaTeXFontShape(this.application_.getCurrentLaTeXFontShape());
        this.setLaTeXFontSize(this.application_.getCurrentLaTeXFontSize());
        this.setHalign(this.application_.getCurrentPGFHAlign());
        this.setValign(this.application_.getCurrentPGFVAlign());
        super.initialise();
    }

    @Override
    public void okay() {
        int n = this.linestylePanel.getJoinStyle();
        if (n == 0 && this.linestylePanel.getEnteredMitreLimit() < 1.0) {
            JDRResources.error((Component)this, JDRResources.getString("error.invalid_mitre_limit"));
            return;
        }
        this.application_.setCurrentSettings(this.getLinePaint(), this.getFillPaint(), this.getTextPaint(), this.getStroke(), this.getFontName(), this.getFontSize(), this.getFontSeries(), this.getFontShape(), this.getLaTeXFontFamily(), this.getLaTeXFontSize(), this.getLaTeXFontSeries(), this.getLaTeXFontShape(), this.getHalign(), this.getValign());
        super.okay();
    }

    @Override
    public JDRPaint getLinePaint() {
        return this.linePanel.getPaint();
    }

    public void setLinePaint(JDRPaint jDRPaint) {
        this.linePanel.setPaint(jDRPaint);
    }

    @Override
    public JDRPaint getTextPaint() {
        if (this.textPanel == null) {
            return null;
        }
        return this.textPanel.getPaint();
    }

    public void setTextPaint(JDRPaint jDRPaint) {
        this.textPanel.setPaint(jDRPaint);
    }

    @Override
    public JDRPaint getFillPaint() {
        return this.fillPanel.getPaint();
    }

    public void setFillPaint(JDRPaint jDRPaint) {
        this.fillPanel.setPaint(jDRPaint);
    }

    @Override
    public JDRBasicStroke getStroke() {
        if (this.linestylePanel == null) {
            return null;
        }
        return this.linestylePanel.getStroke();
    }

    public void setStroke(JDRBasicStroke jDRBasicStroke) {
        this.linestylePanel.setStroke(jDRBasicStroke);
    }

    @Override
    public String getFontName() {
        if (this.fontPanel == null) {
            return "Serif";
        }
        return this.fontPanel.getFontName();
    }

    public void setFontName(String string) {
        this.fontPanel.setFontName(string);
    }

    @Override
    public int getFontSize() {
        if (this.fontPanel == null) {
            return 10;
        }
        return this.fontPanel.getFontSize();
    }

    public void setFontSize(int n) {
        this.fontPanel.setFontSize(n);
    }

    @Override
    public int getFontSeries() {
        if (this.fontPanel == null) {
            return 0;
        }
        return this.fontPanel.getFontSeries();
    }

    public void setFontSeries(int n) {
        this.fontPanel.setFontSeries(n);
    }

    @Override
    public int getFontShape() {
        if (this.fontPanel == null) {
            return 0;
        }
        return this.fontPanel.getFontShape();
    }

    public void setFontShape(int n) {
        this.fontPanel.setFontShape(n);
    }

    public String getLaTeXFontFamily() {
        return this.fontPanel.getLaTeXFontFamily();
    }

    public void setLaTeXFontFamily(String string) {
        this.fontPanel.setLaTeXFontFamily(string);
    }

    public String getLaTeXFontShape() {
        return this.fontPanel.getLaTeXFontShape();
    }

    public void setLaTeXFontShape(String string) {
        this.fontPanel.setLaTeXFontShape(string);
    }

    public String getLaTeXFontSeries() {
        return this.fontPanel.getLaTeXFontSeries();
    }

    public void setLaTeXFontSeries(String string) {
        this.fontPanel.setLaTeXFontSeries(string);
    }

    public String getLaTeXFontSize() {
        return this.fontPanel.getLaTeXFontSize();
    }

    public void setLaTeXFontSize(String string) {
        this.fontPanel.setLaTeXFontSize(string);
    }

    @Override
    public int getHalign() {
        if (this.fontPanel == null) {
            return 0;
        }
        return this.fontPanel.getHalign();
    }

    @Override
    public int getValign() {
        if (this.fontPanel == null) {
            return 0;
        }
        return this.fontPanel.getValign();
    }

    public void setHalign(int n) {
        this.fontPanel.setHalign(n);
    }

    public void setValign(int n) {
        this.fontPanel.setValign(n);
    }

    @Override
    public void setDefaults() {
        this.setLinePaint(new JDRColor(Color.black));
        this.setTextPaint(new JDRColor(Color.black));
        this.setFillPaint(new JDRTransparent());
        this.linestylePanel.setDefaults();
        this.fontPanel.setDefaults();
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "StyleSelector:" + string;
        return string2 + super.info();
    }
}

