/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRText;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.SamplePanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class SampleTextPanel
extends JPanel
implements SamplePanel {
    private JDRSelector panel;
    private JDRText sampleText;
    private double[] matrix;
    private boolean showAnchor = false;

    public SampleTextPanel(JDRSelector jDRSelector) {
        this(jDRSelector, false);
    }

    public SampleTextPanel(JDRSelector jDRSelector, boolean bl) {
        this.setBackground(Color.white);
        this.showAnchor = bl;
        BevelBorder bevelBorder = new BevelBorder(1, new Color(154, 154, 154), Color.darkGray);
        this.setBorder(bevelBorder);
        this.panel = jDRSelector;
        this.sampleText = new JDRText();
        this.matrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    }

    public String getSampleText() {
        return this.panel.getSampleText();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        double d;
        super.paintComponent(graphics);
        String string = this.sampleText.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.updateStyle(graphics2D);
        Dimension dimension = this.getSize();
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHints(this.panel.getRenderingHints());
        this.matrix[0] = d = JDRUnit.getNormalizingFactor();
        this.matrix[3] = d;
        this.sampleText.setTransformation(this.matrix);
        BBox bBox = this.sampleText.getBBox();
        this.sampleText.setPosition(0.5 * (double)dimension.width - bBox.getMidX(), 0.5 * (double)dimension.height - bBox.getMidY());
        if (this.showAnchor) {
            this.sampleText.drawWithAnchors(graphics2D, Color.red);
        } else {
            this.sampleText.draw(graphics2D);
        }
        graphics2D.setRenderingHints(renderingHints);
    }

    @Override
    public void updateSamples() {
        Graphics graphics = this.getGraphics();
        this.updateStyle(graphics);
        if (graphics != null) {
            graphics.dispose();
            this.validate();
            this.repaint();
        }
    }

    protected void updateStyle(Graphics graphics) {
        try {
            this.sampleText.setText(graphics, this.getSampleText());
            this.sampleText.setTextPaint(this.panel.getTextPaint());
            this.sampleText.setFontFamily(graphics, this.panel.getFontName());
            this.sampleText.setFontSize(graphics, this.panel.getFontSize());
            this.sampleText.setFontSeries(graphics, this.panel.getFontSeries());
            this.sampleText.setFontShape(graphics, this.panel.getFontShape());
            this.sampleText.setHAlign(this.panel.getHalign());
            this.sampleText.setVAlign(this.panel.getValign());
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    public BBox getBBox() {
        return this.sampleText.getBBox();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.panel == null || this.sampleText == null) {
            return super.getPreferredSize();
        }
        BBox bBox = this.getBBox();
        double d = JDRUnit.getNormalizingFactor();
        return new Dimension((int)Math.ceil(bBox.getWidth() * d) + 20, (int)Math.ceil(bBox.getHeight() * d) + 20);
    }
}

