/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.InvalidPathException;
import uk.ac.uea.cmp.nlct.jdr.JDRBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRLine;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.SamplePanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class SamplePathPanel
extends JPanel
implements SamplePanel {
    private JDRSelector panel;
    private JDRPath[] path;
    private static final int MAX_PATHS = 7;

    public SamplePathPanel(JDRSelector jDRSelector) {
        this(jDRSelector, true);
    }

    public SamplePathPanel(JDRSelector jDRSelector, boolean bl) {
        this.setBackground(Color.white);
        BevelBorder bevelBorder = new BevelBorder(1, new Color(154, 154, 154), Color.darkGray);
        this.setBorder(bevelBorder);
        this.panel = jDRSelector;
        this.path = new JDRPath[7];
        int n = bl ? 0 : 100;
        int n2 = bl ? 60 : 0;
        int n3 = 0;
        int n4 = bl ? -120 : -140;
        try {
            this.path[0] = new JDRPath();
            this.path[0].add(new JDRLine(new Point(20 + n3, 200 + n4), new Point(60 + n3, 150 + n4)));
            this.path[0].add(new JDRLine(new Point(60 + n3, 150 + n4), new Point(80 + n3, 180 + n4)));
            this.path[1] = new JDRPath();
            this.path[1].add(new JDRLine(new Point(20 + (n3 += n), 200 + (n4 += n2)), new Point(40 + n3, 160 + n4)));
            this.path[1].add(new JDRLine(new Point(40 + n3, 160 + n4), new Point(70 + n3, 220 + n4)));
            this.path[1].add(new JDRLine(new Point(70 + n3, 220 + n4), new Point(80 + n3, 180 + n4)));
            this.path[1].close();
            this.path[2] = new JDRPath();
            this.path[2].add(new JDRBezier(new Point(20 + (n3 += n), 200 + (n4 += n2)), new Point(50 + n3, 170 + n4), new Point(50 + n3, 230 + n4), new Point(80 + n3, 200 + n4)));
            this.path[3] = new JDRPath();
            this.path[3].add(new JDRBezier(new Point(20 + (n3 += n), 200 + (n4 += n2)), new Point(20 + n3, 180 + n4), new Point(50 + n3, 180 + n4), new Point(50 + n3, 200 + n4)));
            this.path[3].add(new JDRBezier(new Point(50 + n3, 200 + n4), new Point(50 + n3, 220 + n4), new Point(80 + n3, 220 + n4), new Point(80 + n3, 200 + n4)));
            this.path[3].add(new JDRBezier(new Point(80 + n3, 200 + n4), new Point(80 + n3, 180 + n4), new Point(50 + n3, 180 + n4), new Point(50 + n3, 200 + n4)));
            this.path[3].close(new JDRBezier(new Point(50 + n3, 200 + n4), new Point(50 + n3, 220 + n4), new Point(20 + n3, 220 + n4), new Point(20 + n3, 100 + n4)));
            this.path[4] = new JDRPath();
            this.path[4].add(new JDRLine(new Point(20 + (n3 += n), 180 + (n4 += n2)), new Point(80 + n3, 180 + n4)));
            this.path[4].add(new JDRLine(new Point(80 + n3, 180 + n4), new Point(80 + n3, 220 + n4)));
            this.path[4].add(new JDRLine(new Point(80 + n3, 220 + n4), new Point(20 + n3, 220 + n4)));
            this.path[4].close();
            this.path[5] = new JDRPath();
            this.path[5].add(new JDRLine(new Point(20 + (n3 += n), 180 + (n4 += n2)), new Point(80 + n3, 180 + n4)));
            this.path[5].add(new JDRLine(new Point(80 + n3, 180 + n4), new Point(80 + n3, 220 + n4)));
            this.path[5].add(new JDRLine(new Point(80 + n3, 220 + n4), new Point(20 + n3, 220 + n4)));
            this.path[5].add(new JDRLine(new Point(20 + n3, 220 + n4), new Point(20 + n3, 180 + n4)));
            this.path[5].add(new JDRSegment(new Point(20 + n3, 180 + n4), new Point(30 + n3, 190 + n4)));
            this.path[5].add(new JDRLine(new Point(30 + n3, 190 + n4), new Point(45 + n3, 190 + n4)));
            this.path[5].add(new JDRLine(new Point(45 + n3, 190 + n4), new Point(45 + n3, 210 + n4)));
            this.path[5].add(new JDRLine(new Point(45 + n3, 210 + n4), new Point(30 + n3, 210 + n4)));
            this.path[5].add(new JDRLine(new Point(30 + n3, 210 + n4), new Point(30 + n3, 190 + n4)));
            this.path[5].add(new JDRSegment(new Point(30 + n3, 190 + n4), new Point(55 + n3, 190 + n4)));
            this.path[5].add(new JDRLine(new Point(55 + n3, 190 + n4), new Point(55 + n3, 210 + n4)));
            this.path[5].add(new JDRLine(new Point(55 + n3, 210 + n4), new Point(70 + n3, 210 + n4)));
            this.path[5].add(new JDRLine(new Point(70 + n3, 210 + n4), new Point(70 + n3, 190 + n4)));
            this.path[5].add(new JDRLine(new Point(70 + n3, 190 + n4), new Point(55 + n3, 190 + n4)));
            n3 += n;
            n4 += n2;
            this.path[6] = new JDRPath();
            if (bl) {
                this.path[6].add(new JDRLine(new Point(20 + n3, 200 + n4), new Point(80 + n3, 200 + n4)));
            } else {
                this.path[6].add(new JDRLine(new Point(20 + n3, 180 + n4), new Point(20 + n3, 220 + n4)));
            }
        }
        catch (InvalidPathException invalidPathException) {
            JDRResources.internalError((Component)this, invalidPathException);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        Stroke stroke = graphics2D.getStroke();
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHints(this.panel.getRenderingHints());
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(0.5 * (double)dimension.width - bBox.getMidX(), 0.5 * (double)dimension.height - bBox.getMidY());
        for (int i = 0; i < 7; ++i) {
            this.path[i].draw(graphics2D, false);
        }
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setStroke(stroke);
        graphics2D.setTransform(affineTransform);
    }

    public BBox getBBox() {
        if (this.panel == null || this.path == null || this.path[0] == null || this.panel.getStroke() == null) {
            return null;
        }
        BBox bBox = null;
        for (int i = 0; i < 7; ++i) {
            if (this.path[i].getStroke() == null) {
                this.path[i].setStroke(this.panel.getStroke());
            }
            if (bBox == null) {
                bBox = this.path[i].getBBox();
                continue;
            }
            this.path[i].mergeBBox(bBox);
        }
        return bBox;
    }

    @Override
    public void updateSamples() {
        if (this.panel == null) {
            return;
        }
        JDRPaint jDRPaint = this.panel.getLinePaint();
        JDRPaint jDRPaint2 = this.panel.getFillPaint();
        JDRStroke jDRStroke = this.panel.getStroke();
        for (int i = 0; i < 7; ++i) {
            this.path[i].setLinePaint(jDRPaint);
            this.path[i].setFillPaint(jDRPaint2);
            this.path[i].setStroke(jDRStroke);
        }
        this.validate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.path == null || this.panel == null) {
            return super.getPreferredSize();
        }
        BBox bBox = this.getBBox();
        return new Dimension((int)Math.ceil(bBox.getWidth()) + 10, (int)Math.ceil(bBox.getHeight()) + 10);
    }
}

