/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.SamplePanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.UnicodePanel;

public class SampleCharPanel
extends JPanel
implements SamplePanel {
    private UnicodePanel unicodePanel;

    public SampleCharPanel(UnicodePanel unicodePanel) {
        this.unicodePanel = unicodePanel;
        this.setSize(new Dimension(60, 50));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics);
        RenderingHints renderingHints = this.unicodePanel.getSymbolRenderingHints();
        if (renderingHints != null) {
            graphics2D.setRenderingHints(renderingHints);
        }
        Font font = graphics2D.getFont();
        Font font2 = this.unicodePanel.getSymbolFont();
        if (font2 == null) {
            font2 = font;
        } else {
            graphics2D.setFont(font2);
        }
        double d = 8.0;
        Rectangle rectangle = this.getBounds();
        graphics2D.setPaint(Color.black);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
        TextLayout textLayout = new TextLayout("" + this.unicodePanel.getSymbol(), font2, fontRenderContext);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d, d);
        Shape shape = textLayout.getOutline(affineTransform);
        Rectangle2D rectangle2D = shape.getBounds2D();
        affineTransform.setToIdentity();
        affineTransform.translate(0.5 * (rectangle.getWidth() - rectangle2D.getWidth()) - rectangle2D.getX(), 0.5 * (rectangle.getHeight() - rectangle2D.getHeight()) - rectangle2D.getY());
        graphics2D.fill(affineTransform.createTransformedShape(shape));
        graphics2D.setFont(font);
    }

    @Override
    public void updateSamples() {
        this.repaint();
    }
}

