/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternAdjustPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternAnchorPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetryLinePoint;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.NonNegativeLengthPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.ControlPaintPanel;

class RenderPanel
extends JPanel {
    private JRadioButton antialiasOn;
    private JRadioButton antialiasOff;
    private JRadioButton quality;
    private JRadioButton speed;
    private NonNegativeLengthPanel controlSize;
    private ControlPaintPanel[] controlPaintPanels;

    public RenderPanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 3));
        jPanel2.add(new JLabel(JDRResources.getString("render.anti_alias") + " "));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.antialiasOn = new JRadioButton(JDRResources.getString("render.on") + " ", false);
        this.antialiasOn.setMnemonic(JDRResources.getChar("render.on.mnemonic"));
        buttonGroup.add(this.antialiasOn);
        jPanel2.add(this.antialiasOn);
        this.antialiasOff = new JRadioButton(JDRResources.getString("render.off") + " ", true);
        this.antialiasOff.setMnemonic(JDRResources.getChar("render.off.mnemonic"));
        buttonGroup.add(this.antialiasOff);
        jPanel2.add(this.antialiasOff);
        jPanel2.add(new JLabel(JDRResources.getString("render.rendering") + " "));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.quality = new JRadioButton(JDRResources.getString("render.quality") + " ", false);
        this.quality.setMnemonic(JDRResources.getChar("render.quality.mnemonic"));
        buttonGroup2.add(this.quality);
        jPanel2.add(this.quality);
        this.speed = new JRadioButton(JDRResources.getString("render.speed") + " ", true);
        this.speed.setMnemonic(JDRResources.getChar("render.speed.mnemonic"));
        buttonGroup2.add(this.speed);
        jPanel2.add(this.speed);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        JLabel jLabel = new JLabel(JDRResources.getString("render.control_size") + " ");
        jLabel.setDisplayedMnemonic(JDRResources.getChar("render.control_size.mnemonic"));
        jPanel2.add(jLabel);
        this.controlSize = new NonNegativeLengthPanel();
        jLabel.setLabelFor(this.controlSize.getTextField());
        this.controlSize.setValue(10.0);
        jPanel2.add(this.controlSize);
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "North");
        jPanel2 = new JPanel(new GridLayout(2, 2));
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.controlPaintPanels = new ControlPaintPanel[8];
        this.addControlPaintPanels(jPanel2, 0, "standard", new JDRPoint());
        this.addControlPaintPanels(jPanel2, 2, "symmetry", new JDRSymmetryLinePoint());
        this.add(jPanel2);
        this.addControlPaintPanels(jPanel2, 4, "patternanchor", new JDRPatternAnchorPoint());
        this.addControlPaintPanels(jPanel2, 6, "patternadjust", new JDRPatternAdjustPoint());
        this.add((Component)jPanel2, "Center");
        Dimension dimension = this.controlPaintPanels[0].getLabel().getPreferredSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        dimension = this.controlPaintPanels[1].getLabel().getPreferredSize();
        if (dimension.getWidth() > d) {
            d = dimension.getWidth();
        }
        if (dimension.getHeight() > d2) {
            d2 = dimension.getHeight();
        }
        dimension.setSize(d, d2);
        for (int i = 0; i < this.controlPaintPanels.length; ++i) {
            this.controlPaintPanels[i].getLabel().setPreferredSize(dimension);
        }
    }

    private void addControlPaintPanels(JComponent jComponent, int n, String string, JDRPoint jDRPoint) {
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JDRResources.getString("render.control." + string)));
        this.controlPaintPanels[n] = new ControlPaintPanel(jDRPoint, JDRResources.getStringWithValue("render.control.choosertitle", new String[]{JDRResources.getString("render.control." + string), JDRResources.getString("render.control.unselected")}));
        box.add(this.controlPaintPanels[n]);
        JDRPoint jDRPoint2 = (JDRPoint)jDRPoint.clone();
        jDRPoint2.setSelected(true);
        this.controlPaintPanels[n + 1] = new ControlPaintPanel(jDRPoint2, JDRResources.getStringWithValue("render.control.choosertitle", new String[]{JDRResources.getString("render.control." + string), JDRResources.getString("render.control.selected")}));
        box.add(this.controlPaintPanels[n + 1]);
        jComponent.add(box);
    }

    public void initialise(JpgfDraw jpgfDraw) {
        if (jpgfDraw.getAntiAlias()) {
            this.antialiasOn.setSelected(true);
        } else {
            this.antialiasOff.setSelected(true);
        }
        if (jpgfDraw.getRenderQuality()) {
            this.quality.setSelected(true);
        } else {
            this.speed.setSelected(true);
        }
        this.controlSize.setValue(JDRPoint.pointSize);
    }

    public void okay(JpgfDraw jpgfDraw) {
        JpgfDraw.setRendering(this.antialiasOn.isSelected(), this.quality.isSelected());
        JDRPoint.pointSize = this.controlSize.getValue();
        for (int i = 0; i < this.controlPaintPanels.length; ++i) {
            this.controlPaintPanels[i].updatePaint();
        }
        jpgfDraw.repaint();
    }
}

