/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.geom.Point2D;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import uk.ac.uea.cmp.nlct.jdr.InvalidGridArgumentException;
import uk.ac.uea.cmp.nlct.jdr.JDRGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRRadialGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.NonNegativeIntField;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.GridPanel;

public class RadialGridPanel
extends GridPanel {
    private NonNegativeIntField majorDivisions;
    private NonNegativeIntField subDivisions;
    private NonNegativeIntField spokes;
    private JComboBox unitBox;
    private JLabel spokesLabel;

    public RadialGridPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        JLabel jLabel = new JLabel(JDRResources.getString("grid.major"));
        jLabel.setDisplayedMnemonic(JDRResources.getChar("grid.major.mnemonic"));
        this.add((Component)jLabel, gridBagConstraints);
        this.majorDivisions = new NonNegativeIntField(100);
        jLabel.setLabelFor(this.majorDivisions);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.majorDivisions, gridBagConstraints);
        this.unitBox = new JComboBox<String>(new String[]{"pt", "in", "cm", "bp"});
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.unitBox, gridBagConstraints);
        this.subDivisions = new NonNegativeIntField(10);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        JLabel jLabel2 = new JLabel(JDRResources.getString("grid.sub_divisions"));
        this.add((Component)jLabel2, gridBagConstraints);
        jLabel2.setDisplayedMnemonic(JDRResources.getChar("grid.sub_divisions.mnemonic"));
        jLabel2.setLabelFor(this.subDivisions);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.subDivisions, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        this.spokes = new NonNegativeIntField(8);
        this.spokesLabel = new JLabel(JDRResources.getString("grid.spokes"));
        this.spokesLabel.setDisplayedMnemonic(JDRResources.getChar("grid.spokes.mnemonic"));
        this.spokesLabel.setLabelFor(this.spokes);
        this.add((Component)this.spokesLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.spokes, gridBagConstraints);
    }

    @Override
    public void requestDefaultFieldFocus() {
        this.majorDivisions.requestFocusInWindow();
    }

    @Override
    public void setGrid(JDRGrid jDRGrid) {
        this.majorDivisions.setValue((int)((JDRRadialGrid)jDRGrid).getMajorInterval());
        this.subDivisions.setValue(((JDRRadialGrid)jDRGrid).getSubDivisions());
        this.setUnit(((JDRRadialGrid)jDRGrid).getUnit());
        this.spokes.setValue(((JDRRadialGrid)jDRGrid).getSpokes());
    }

    @Override
    public JDRGrid getGrid(JDRGrid jDRGrid) {
        int n;
        Point2D point2D = jDRGrid.getMinorTicDistance();
        double d = Math.min(point2D.getX(), point2D.getY());
        if (d < 4.0 && (n = JOptionPane.showConfirmDialog(this, JDRResources.getString("warning.grid_too_fine"), JDRResources.getString("warning.title"), 0, 2)) != 0) {
            return null;
        }
        try {
            if (jDRGrid instanceof JDRRadialGrid) {
                JDRRadialGrid jDRRadialGrid = (JDRRadialGrid)jDRGrid;
                jDRRadialGrid.set(this.getUnit(), this.getMajor(), this.getSubDivisions(), this.getSpokes());
            } else {
                jDRGrid = new JDRRadialGrid(this.getUnit(), this.getMajor(), this.getSubDivisions(), this.getSpokes());
            }
        }
        catch (InvalidGridArgumentException invalidGridArgumentException) {
            // empty catch block
        }
        return jDRGrid;
    }

    public int getSpokes() {
        int n = this.spokes.getValue();
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public double getMajor() {
        double d = this.majorDivisions.getValue();
        if (d == 0.0) {
            d = 1.0;
        }
        return d;
    }

    public int getSubDivisions() {
        int n = this.subDivisions.getValue();
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public void setUnit(JDRUnit jDRUnit) {
        this.unitBox.setSelectedItem(jDRUnit.getLabel());
    }

    public JDRUnit getUnit() {
        switch (this.unitBox.getSelectedIndex()) {
            case 0: {
                return JDRUnit.pt;
            }
            case 1: {
                return JDRUnit.in;
            }
            case 2: {
                return JDRUnit.cm;
            }
            case 3: {
                return JDRUnit.bp;
            }
        }
        return JDRUnit.bp;
    }
}

