/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdr.JDRRadialPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.NonNegativeLengthPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.AnglePanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.CoordPanel;

public class RadialCoordPanel
extends JPanel
implements CoordPanel {
    private NonNegativeLengthPanel radiusPanel = new NonNegativeLengthPanel(JDRResources.getString("coordinates.radius") + " ", JDRResources.getChar("coordinates.radius.mnemonic"));
    private AnglePanel anglePanel;
    private JDRPaper paper;

    public RadialCoordPanel() {
        this.add(this.radiusPanel);
        this.anglePanel = new AnglePanel(JDRResources.getString("coordinates.angle") + " ", JDRResources.getChar("coordinates.angle.mnemonic"));
        this.add(this.anglePanel);
        this.setName(JDRResources.getString("grid.radial"));
    }

    @Override
    public void requestCoordFocus() {
        this.radiusPanel.getTextField().requestFocusInWindow();
    }

    @Override
    public void setCoords(double d, double d2, JDRUnit jDRUnit, JDRPaper jDRPaper) {
        this.paper = jDRPaper;
        JDRRadialPoint jDRRadialPoint = new JDRRadialPoint();
        jDRRadialPoint.setLocation(jDRUnit.toBp(d) - 0.5 * jDRPaper.getWidth(), jDRUnit.toBp(d2) - 0.5 * jDRPaper.getHeight());
        this.radiusPanel.setUnit(jDRUnit);
        this.radiusPanel.setBpValue(jDRRadialPoint.getRadius());
        this.anglePanel.setValue(jDRRadialPoint.getAngle());
    }

    @Override
    public double getXCoord() {
        return this.radiusPanel.getValue() * Math.cos(this.anglePanel.getRadians()) + 0.5 * this.paper.getWidth();
    }

    @Override
    public double getYCoord() {
        return this.radiusPanel.getValue() * Math.sin(this.anglePanel.getRadians()) + 0.5 * this.paper.getHeight();
    }
}

