/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRRotationalPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRScaledPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRSpiralPattern;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.DoubleField;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.NonNegativeIntField;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.NonNegativeLengthPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.AnglePanel;

public class PatternDialogBox
extends JDialog
implements ActionListener {
    private AnglePanel rotAnglePanel;
    private AnglePanel spiralAnglePanel;
    private DoubleField scaleXField;
    private DoubleField scaleYField;
    private NonNegativeLengthPanel spiralDistancePanel;
    private NonNegativeIntField replicaField;
    private JpgfDraw application_;
    private JRadioButton singlePath;
    private JRadioButton multiPath;
    private JCheckBox showPath;
    private JTabbedPane tabbedPane;
    private int index = -1;
    private JPanel rotPanel;
    private JPanel scaledPanel;
    private JPanel spiralPanel;

    public PatternDialogBox(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("pattern.title"), true);
        this.application_ = jpgfDraw;
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(JDRResources.getString("pattern.replicas"));
        jLabel.setDisplayedMnemonic(JDRResources.getChar("pattern.replicas.mnemonic"));
        jPanel.add(jLabel);
        this.replicaField = new NonNegativeIntField(1);
        jLabel.setLabelFor(this.replicaField);
        jPanel.add(this.replicaField);
        JLabel jLabel2 = new JLabel(JDRResources.getString("pattern.mode"));
        jPanel.add(jLabel2);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.singlePath = new JRadioButton(JDRResources.getString("pattern.mode.single"), true);
        this.singlePath.setMnemonic(JDRResources.getChar("pattern.mode.single.mnemonic"));
        buttonGroup.add(this.singlePath);
        jPanel.add(this.singlePath);
        this.multiPath = new JRadioButton(JDRResources.getString("pattern.mode.multi"), false);
        this.multiPath.setMnemonic(JDRResources.getChar("pattern.mode.multi.mnemonic"));
        buttonGroup.add(this.multiPath);
        jPanel.add(this.multiPath);
        box.add(jPanel);
        this.showPath = new JCheckBox(JDRResources.getString("pattern.show_original"), true);
        this.showPath.setMnemonic(JDRResources.getChar("pattern.show_original.mnemonic"));
        box.add(this.showPath);
        this.tabbedPane = new JTabbedPane();
        this.rotPanel = new JPanel();
        this.rotAnglePanel = new AnglePanel(JDRResources.getString("rotate.label") + " ", JDRResources.getChar("rotate.mnemonic"));
        this.rotAnglePanel.setDegrees(90.0);
        this.rotPanel.add(this.rotAnglePanel);
        this.tabbedPane.addTab(JDRResources.getString("pattern.rotational"), null, this.rotPanel);
        this.tabbedPane.setMnemonicAt(0, JDRResources.getChar("pattern.rotational.mnemonic"));
        this.scaledPanel = new JPanel();
        jLabel = new JLabel(JDRResources.getString("scale.x") + " ");
        this.scaledPanel.add(jLabel);
        jLabel.setDisplayedMnemonic(JDRResources.getChar("scale.x.mnemonic"));
        this.scaleXField = new DoubleField(2.0);
        jLabel.setLabelFor(this.scaleXField);
        this.scaledPanel.add(this.scaleXField);
        jLabel = new JLabel(JDRResources.getString("scale.y") + " ");
        this.scaledPanel.add(jLabel);
        jLabel.setDisplayedMnemonic(JDRResources.getChar("scale.y.mnemonic"));
        this.scaleYField = new DoubleField(2.0);
        jLabel.setLabelFor(this.scaleYField);
        this.scaledPanel.add(this.scaleYField);
        this.tabbedPane.addTab(JDRResources.getString("pattern.scaled"), null, this.scaledPanel);
        this.tabbedPane.setMnemonicAt(1, JDRResources.getChar("pattern.scaled.mnemonic"));
        this.spiralPanel = new JPanel();
        this.spiralAnglePanel = new AnglePanel(JDRResources.getString("rotate.label") + " ", JDRResources.getChar("rotate.mnemonic"));
        this.spiralAnglePanel.setDegrees(20.0);
        this.spiralPanel.add(this.spiralAnglePanel);
        this.spiralDistancePanel = new NonNegativeLengthPanel(JDRResources.getString("pattern.spiral.distance") + " ", JDRResources.getChar("pattern.spiral.distance.mnemonic"));
        this.spiralDistancePanel.setValue(10.0);
        this.spiralPanel.add(this.spiralDistancePanel);
        this.tabbedPane.addTab(JDRResources.getString("pattern.spiral"), null, this.spiralPanel);
        this.tabbedPane.setMnemonicAt(2, JDRResources.getChar("pattern.spiral.mnemonic"));
        box.add(this.tabbedPane);
        this.getContentPane().add((Component)box, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(JDRResources.createOkayButton(this));
        jPanel2.add(JDRResources.createCancelButton(this));
        jPanel2.add(JDRResources.createHelpButton("sec:pattern"));
        this.getContentPane().add((Component)jPanel2, "South");
        this.pack();
        this.setLocationRelativeTo(jpgfDraw);
    }

    public void display() {
        this.display(-1);
    }

    public void display(int n) {
        JDRCompleteObject jDRCompleteObject;
        JDRPattern jDRPattern = null;
        this.index = n;
        if (this.index != -1) {
            jDRCompleteObject = this.application_.getCurrentFrame().getObject(this.index);
            jDRPattern = jDRCompleteObject.getPattern();
        }
        if (jDRPattern != null) {
            this.replicaField.setValue(jDRPattern.getNumReplicas());
            if (jDRPattern instanceof JDRRotationalPattern) {
                jDRCompleteObject = (JDRRotationalPattern)jDRPattern;
                this.rotAnglePanel.setValue(((JDRRotationalPattern)jDRCompleteObject).getRotationAngle());
                this.tabbedPane.setSelectedComponent(this.rotPanel);
            } else if (jDRPattern instanceof JDRScaledPattern) {
                jDRCompleteObject = (JDRScaledPattern)jDRPattern;
                this.scaleXField.setValue(((JDRScaledPattern)jDRCompleteObject).getScaleX());
                this.scaleYField.setValue(((JDRScaledPattern)jDRCompleteObject).getScaleY());
                this.tabbedPane.setSelectedComponent(this.scaledPanel);
            } else if (jDRPattern instanceof JDRSpiralPattern) {
                jDRCompleteObject = (JDRSpiralPattern)jDRPattern;
                this.spiralAnglePanel.setValue(((JDRSpiralPattern)jDRCompleteObject).getRotationAngle());
                this.spiralDistancePanel.setValue(((JDRSpiralPattern)jDRCompleteObject).getDistance());
                this.tabbedPane.setSelectedComponent(this.spiralPanel);
            }
            if (jDRPattern.isSinglePath()) {
                this.singlePath.setSelected(true);
            } else {
                this.multiPath.setSelected(true);
            }
            this.showPath.setSelected(jDRPattern.showOriginal());
        }
        this.setVisible(true);
        this.replicaField.requestFocusInWindow();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("okay")) {
            this.okay();
        } else if (string.equals("cancel")) {
            this.setVisible(false);
        }
    }

    public JDRPattern getPattern() throws InvalidFormatException {
        Component component = this.tabbedPane.getSelectedComponent();
        int n = this.replicaField.getValue();
        if (n < 1) {
            n = 1;
        }
        if (component == this.rotPanel) {
            return new JDRRotationalPattern(null, null, this.rotAnglePanel.getRadians(), n, this.singlePath.isSelected(), this.showPath.isSelected());
        }
        if (component == this.scaledPanel) {
            double d = this.scaleXField.getValue();
            double d2 = this.scaleYField.getValue();
            if (d == 0.0) {
                d = 1.0;
            }
            if (d2 == 0.0) {
                d2 = 1.0;
            }
            return new JDRScaledPattern(null, null, d, d2, n, this.singlePath.isSelected(), this.showPath.isSelected());
        }
        if (component == this.spiralPanel) {
            return new JDRSpiralPattern(null, null, null, this.spiralAnglePanel.getRadians(), this.spiralDistancePanel.getValue(), n, this.singlePath.isSelected(), this.showPath.isSelected());
        }
        throw new InvalidFormatException("No tab selected");
    }

    public void okay() {
        JDRPattern jDRPattern = null;
        try {
            jDRPattern = this.getPattern();
        }
        catch (InvalidFormatException invalidFormatException) {
            JDRResources.internalError(null, invalidFormatException);
            return;
        }
        this.setVisible(false);
        if (this.index == -1) {
            this.application_.getCurrentFrame().convertSelectedToPattern(jDRPattern);
        } else {
            this.application_.getCurrentFrame().updatePattern(this.index, jDRPattern);
        }
    }

    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = string2 + "RotationalPatternDialogBox:" + string;
        string2 = string2 + "has focus: " + this.hasFocus() + string;
        string2 = string2 + "replica field has focus: " + this.replicaField.hasFocus() + string;
        ActionMap actionMap = this.getRootPane().getActionMap();
        string2 = string2 + "action map: " + string;
        Object[] objectArray = actionMap.allKeys();
        for (int i = 0; i < objectArray.length; ++i) {
            string2 = string2 + "Key: " + objectArray[i] + " Action: " + actionMap.get(objectArray[i]) + string;
        }
        return string2 + string;
    }
}

