/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import uk.ac.uea.cmp.nlct.jdr.JDRGradient;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRRadial;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparent;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.ColorPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.GradientPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class PaintPanel
extends JPanel
implements AdjustmentListener,
ActionListener {
    private JRadioButton transparentButton;
    private JRadioButton singleColourButton;
    private JRadioButton gradientColourButton;
    private ColorPanel singleColourPanel;
    private GradientPanel gradientPanel;
    private JPanel nonePanel;
    private JPanel cards;
    private static final String NONEPANEL = "None Panel";
    private static final String COLOURPANEL = "Colour Panel";
    private static final String GRADIENTPANEL = "Gradient Panel";
    private JDRSelector selector_;

    public PaintPanel(JDRSelector jDRSelector) {
        this.selector_ = jDRSelector;
        this.setLayout(new BoxLayout(this, 0));
        Box box = Box.createVerticalBox();
        box.setAlignmentY(0.0f);
        this.cards = new JPanel(new CardLayout());
        this.cards.setAlignmentY(0.0f);
        this.cards.setBorder(BorderFactory.createLoweredBevelBorder());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.transparentButton = new JRadioButton(JDRResources.getString("colour.transparent"));
        this.transparentButton.setMnemonic(JDRResources.getChar("colour.transparent.mnemonic"));
        this.transparentButton.addActionListener(this);
        this.transparentButton.setAlignmentX(0.0f);
        buttonGroup.add(this.transparentButton);
        box.add(this.transparentButton);
        this.nonePanel = new JPanel();
        this.nonePanel.setAlignmentY(0.0f);
        this.cards.add((Component)this.nonePanel, NONEPANEL);
        this.singleColourButton = new JRadioButton(JDRResources.getString("colour.single"));
        this.singleColourButton.setMnemonic(JDRResources.getChar("colour.single.mnemonic"));
        this.singleColourButton.addActionListener(this);
        this.singleColourButton.setAlignmentX(0.0f);
        buttonGroup.add(this.singleColourButton);
        box.add(this.singleColourButton);
        this.singleColourPanel = new ColorPanel(this);
        this.singleColourPanel.setAlignmentY(0.0f);
        this.singleColourPanel.setMnemonics(JDRResources.getChar("colour.rgb.mnemonic"), JDRResources.getChar("colour.cmyk.mnemonic"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.singleColourPanel, "North");
        this.cards.add((Component)jPanel, COLOURPANEL);
        this.gradientColourButton = new JRadioButton(JDRResources.getString("colour.gradient"));
        this.gradientColourButton.setMnemonic(JDRResources.getChar("colour.gradient.mnemonic"));
        this.gradientColourButton.addActionListener(this);
        this.gradientColourButton.setAlignmentX(0.0f);
        buttonGroup.add(this.gradientColourButton);
        box.add(this.gradientColourButton);
        this.gradientPanel = new GradientPanel(jDRSelector);
        this.gradientPanel.setAlignmentY(0.0f);
        this.cards.add((Component)this.gradientPanel, GRADIENTPANEL);
        Dimension dimension = this.singleColourPanel.getPreferredSize();
        Dimension dimension2 = this.gradientPanel.getPreferredSize();
        dimension2.height -= dimension.height;
        jPanel.add(Box.createRigidArea(dimension2));
        this.add(box);
        this.add(Box.createHorizontalStrut(10));
        this.add(new JScrollPane(this.cards));
    }

    public JDRPaint getPaint() {
        JDRPaint jDRPaint = this.singleColourButton.isSelected() ? this.singleColourPanel.getPaint() : (this.gradientColourButton.isSelected() ? this.gradientPanel.getPaint() : new JDRTransparent());
        return jDRPaint;
    }

    public void setPaint(JDRPaint jDRPaint) {
        if (jDRPaint instanceof JDRTransparent) {
            this.transparentButton.setSelected(true);
            this.selectTransparent();
        } else if (jDRPaint instanceof JDRGradient) {
            this.gradientColourButton.setSelected(true);
            this.selectGradientColour();
            this.gradientPanel.setPaint(jDRPaint);
        } else if (jDRPaint instanceof JDRRadial) {
            this.gradientColourButton.setSelected(true);
            this.selectGradientColour();
            this.gradientPanel.setPaint(jDRPaint);
        } else {
            this.singleColourPanel.setPaint(jDRPaint);
            this.selectSingleColour();
        }
        this.selector_.repaintSample();
    }

    public void selectTransparent() {
        if (!this.transparentButton.isSelected()) {
            this.transparentButton.setSelected(true);
        }
        CardLayout cardLayout = (CardLayout)this.cards.getLayout();
        cardLayout.show(this.cards, NONEPANEL);
    }

    public void selectSingleColour() {
        if (!this.singleColourButton.isSelected()) {
            this.singleColourButton.setSelected(true);
        }
        CardLayout cardLayout = (CardLayout)this.cards.getLayout();
        cardLayout.show(this.cards, COLOURPANEL);
    }

    public void selectGradientColour() {
        if (!this.gradientColourButton.isSelected()) {
            this.gradientColourButton.setSelected(true);
        }
        CardLayout cardLayout = (CardLayout)this.cards.getLayout();
        cardLayout.show(this.cards, GRADIENTPANEL);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.transparentButton) {
            this.selectTransparent();
        } else if (object == this.singleColourButton) {
            this.selectSingleColour();
        } else if (object == this.gradientColourButton) {
            this.selectGradientColour();
        }
        this.selector_.repaintSample();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.selector_.repaintSample();
    }
}

