/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.uea.cmp.nlct.jdr.InvalidMarkerTypeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.DoubleField;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.LengthPanel;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.NonNegativeLengthPanel;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.TextFieldSampleListener;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.ArrowStylePanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.ColorPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.MarkerItem;

public class MarkerPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ChangeListener {
    private JDRSelector selector_;
    private JList arrowStyleBox;
    private JList partialStyleBox;
    private JList dataStyleBox;
    private JList bracketStyleBox;
    private JList shapesStyleBox;
    private JList capStyleBox;
    private static final int ARROW_TAB = 0;
    private static final int PARTIAL_TAB = 1;
    private static final int DATA_TAB = 2;
    private static final int BRACKET_TAB = 3;
    private static final int SHAPES_TAB = 4;
    private static final int CAP_TAB = 5;
    private JTabbedPane markerTabPane;
    private JRadioButton noMarkerButton;
    private JRadioButton useMarkerButton;
    private NonNegativeLengthPanel arrowSize;
    private JRadioButton arrowSingle;
    private JRadioButton arrowDouble;
    private JRadioButton arrowTriple;
    private JCheckBox arrowReverse;
    private JCheckBox autoOrient;
    private DoubleField angleField;
    private JCheckBox autoOffset;
    private LengthPanel offsetField;
    private JCheckBox autoGap;
    private LengthPanel gapField;
    private JRadioButton asLineButton;
    private JRadioButton notAsLineButton;
    private ColorPanel colourPanel;
    public static final MarkerItem noMarkerItem = new MarkerItem(0, JDRResources.getString("arrow.none"));
    public static final MarkerItem[] arrowStyles = new MarkerItem[]{new MarkerItem(1, JDRResources.getString("arrow.pointed")), new MarkerItem(28, JDRResources.getString("arrow.pointed60")), new MarkerItem(29, JDRResources.getString("arrow.pointed45")), new MarkerItem(39, JDRResources.getString("arrow.cusp")), new MarkerItem(7, JDRResources.getString("arrow.latex")), new MarkerItem(42, JDRResources.getString("arrow.altlatex")), new MarkerItem(43, JDRResources.getString("arrow.altlatex.open")), new MarkerItem(2, JDRResources.getString("arrow.triangle")), new MarkerItem(44, JDRResources.getString("arrow.triangle.open")), new MarkerItem(78, JDRResources.getString("arrow.equilateral.filled")), new MarkerItem(79, JDRResources.getString("arrow.equilateral.open")), new MarkerItem(30, JDRResources.getString("arrow.hooks"))};
    public static final MarkerItem[] partialStyles = new MarkerItem[]{new MarkerItem(31, JDRResources.getString("arrow.hook.up")), new MarkerItem(32, JDRResources.getString("arrow.hook.down")), new MarkerItem(33, JDRResources.getString("arrow.halfpointed.up")), new MarkerItem(34, JDRResources.getString("arrow.halfpointed.down")), new MarkerItem(35, JDRResources.getString("arrow.halfpointed60.up")), new MarkerItem(36, JDRResources.getString("arrow.halfpointed60.down")), new MarkerItem(37, JDRResources.getString("arrow.halfpointed45.up")), new MarkerItem(38, JDRResources.getString("arrow.halfpointed45.down")), new MarkerItem(40, JDRResources.getString("arrow.halfcusp.up")), new MarkerItem(41, JDRResources.getString("arrow.halfcusp.down"))};
    public static final MarkerItem[] bracketStyles = new MarkerItem[]{new MarkerItem(5, JDRResources.getString("arrow.square")), new MarkerItem(6, JDRResources.getString("arrow.bar")), new MarkerItem(8, JDRResources.getString("arrow.round")), new MarkerItem(47, JDRResources.getString("arrow.brace")), new MarkerItem(58, JDRResources.getString("arrow.altsquare")), new MarkerItem(56, JDRResources.getString("arrow.altbar")), new MarkerItem(57, JDRResources.getString("arrow.altround")), new MarkerItem(59, JDRResources.getString("arrow.altbrace"))};
    public static final MarkerItem[] shapesStyles = new MarkerItem[]{new MarkerItem(3, JDRResources.getString("arrow.circle")), new MarkerItem(4, JDRResources.getString("arrow.diamond")), new MarkerItem(45, JDRResources.getString("arrow.circle.open")), new MarkerItem(46, JDRResources.getString("arrow.diamond.open")), new MarkerItem(66, JDRResources.getString("arrow.scissors.up.filled")), new MarkerItem(65, JDRResources.getString("arrow.scissors.down.filled")), new MarkerItem(68, JDRResources.getString("arrow.scissors.up.open")), new MarkerItem(67, JDRResources.getString("arrow.scissors.down.open")), new MarkerItem(69, JDRResources.getString("arrow.heart.right.filled")), new MarkerItem(70, JDRResources.getString("arrow.heart.right.open")), new MarkerItem(71, JDRResources.getString("arrow.heart.filled")), new MarkerItem(72, JDRResources.getString("arrow.heart.open")), new MarkerItem(73, JDRResources.getString("arrow.snowflake")), new MarkerItem(74, JDRResources.getString("arrow.starchevron.open")), new MarkerItem(75, JDRResources.getString("arrow.starchevron.filled"))};
    public static final MarkerItem[] dataStyles = new MarkerItem[]{new MarkerItem(9, JDRResources.getString("arrow.dotfilled")), new MarkerItem(10, JDRResources.getString("arrow.dotopen")), new MarkerItem(11, JDRResources.getString("arrow.boxfilled")), new MarkerItem(12, JDRResources.getString("arrow.boxopen")), new MarkerItem(13, JDRResources.getString("arrow.cross")), new MarkerItem(14, JDRResources.getString("arrow.plus")), new MarkerItem(15, JDRResources.getString("arrow.star")), new MarkerItem(64, JDRResources.getString("arrow.asterisk")), new MarkerItem(63, JDRResources.getString("arrow.star5.filled")), new MarkerItem(62, JDRResources.getString("arrow.star5.open")), new MarkerItem(76, JDRResources.getString("arrow.star6.filled")), new MarkerItem(77, JDRResources.getString("arrow.star6.open")), new MarkerItem(16, JDRResources.getString("arrow.triangle.up.filled")), new MarkerItem(17, JDRResources.getString("arrow.triangle.up.open")), new MarkerItem(18, JDRResources.getString("arrow.triangle.down.filled")), new MarkerItem(19, JDRResources.getString("arrow.triangle.down.open")), new MarkerItem(20, JDRResources.getString("arrow.rhombus.filled")), new MarkerItem(21, JDRResources.getString("arrow.rhombus.open")), new MarkerItem(22, JDRResources.getString("arrow.pentagon.filled")), new MarkerItem(23, JDRResources.getString("arrow.pentagon.open")), new MarkerItem(24, JDRResources.getString("arrow.hexagon.filled")), new MarkerItem(25, JDRResources.getString("arrow.hexagon.open")), new MarkerItem(26, JDRResources.getString("arrow.octagon.filled")), new MarkerItem(27, JDRResources.getString("arrow.octagon.open")), new MarkerItem(61, JDRResources.getString("arrow.semicircle.filled")), new MarkerItem(60, JDRResources.getString("arrow.semicircle.open"))};
    public static final MarkerItem[] capStyles = new MarkerItem[]{new MarkerItem(48, JDRResources.getString("arrow.rectanglecap"), 10.0, 50), new MarkerItem(51, JDRResources.getString("arrow.roundcap"), 10.0, 50), new MarkerItem(52, JDRResources.getString("arrow.trianglecap"), 10.0, 50), new MarkerItem(53, JDRResources.getString("arrow.inverttrianglecap"), 10.0, 50), new MarkerItem(49, JDRResources.getString("arrow.chevroncap"), 10.0, 50), new MarkerItem(54, JDRResources.getString("arrow.invertchevroncap"), 10.0, 50), new MarkerItem(50, JDRResources.getString("arrow.fastcap"), 10.0, 50), new MarkerItem(55, JDRResources.getString("arrow.invertfastcap"), 10.0, 50), new MarkerItem(80, JDRResources.getString("arrow.ballcap"), 10.0, 50), new MarkerItem(81, JDRResources.getString("arrow.leafcap"), 10.0, 50), new MarkerItem(82, JDRResources.getString("arrow.doubleleafcap"), 10.0, 50), new MarkerItem(83, JDRResources.getString("arrow.tripleleafcap"), 10.0, 50), new MarkerItem(84, JDRResources.getString("arrow.clubcap"), 10.0, 50), new MarkerItem(85, JDRResources.getString("arrow.tripleleafforwardcap"), 10.0, 50), new MarkerItem(86, JDRResources.getString("arrow.tripleleafbackcap"), 10.0, 50), new MarkerItem(87, JDRResources.getString("arrow.doubleleafforwardcap"), 10.0, 50), new MarkerItem(88, JDRResources.getString("arrow.doubleleafbackcap"), 10.0, 50), new MarkerItem(89, JDRResources.getString("arrow.bulgecap"), 10.0, 50), new MarkerItem(90, JDRResources.getString("arrow.cutoutbulgecap"), 10.0, 50)};
    private ArrowStylePanel arrowStylePanel;

    public MarkerPanel(JDRSelector jDRSelector, ArrowStylePanel arrowStylePanel) {
        this.selector_ = jDRSelector;
        this.arrowStylePanel = arrowStylePanel;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.noMarkerButton = new JRadioButton(JDRResources.getString("arrow.nomarker") + " ", true);
        this.noMarkerButton.setMnemonic(JDRResources.getChar("arrow.nomarker.mnemonic"));
        this.noMarkerButton.addActionListener(this);
        this.noMarkerButton.setAlignmentX(0.0f);
        buttonGroup.add(this.noMarkerButton);
        jPanel.add(this.noMarkerButton);
        this.useMarkerButton = new JRadioButton(JDRResources.getString("arrow.usemarker") + " ");
        this.useMarkerButton.setMnemonic(JDRResources.getChar("arrow.usemarker.mnemonic"));
        this.useMarkerButton.setAlignmentX(0.0f);
        this.useMarkerButton.addActionListener(this);
        buttonGroup.add(this.useMarkerButton);
        jPanel.add(this.useMarkerButton);
        this.markerTabPane = new JTabbedPane();
        this.markerTabPane.setAlignmentX(0.0f);
        this.markerTabPane.addChangeListener(this);
        this.markerTabPane.setToolTipText(JDRResources.getString("tooltip.arrow.type"));
        this.arrowStyleBox = new JList<MarkerItem>(arrowStyles);
        this.arrowStyleBox.setSelectionMode(1);
        this.arrowStyleBox.addListSelectionListener(this);
        this.arrowStyleBox.setCellRenderer(new MarkerItem());
        JScrollPane jScrollPane = new JScrollPane(this.arrowStyleBox);
        this.markerTabPane.addTab(JDRResources.getString("arrow.tab.arrows") + " ", null, jScrollPane, JDRResources.getString("tooltip.arrow.type.arrows"));
        this.partialStyleBox = new JList<MarkerItem>(partialStyles);
        this.partialStyleBox.setSelectionMode(1);
        this.partialStyleBox.addListSelectionListener(this);
        this.partialStyleBox.setCellRenderer(new MarkerItem());
        JScrollPane jScrollPane2 = new JScrollPane(this.partialStyleBox);
        this.markerTabPane.addTab(JDRResources.getString("arrow.tab.partial") + " ", null, jScrollPane2, JDRResources.getString("tooltip.arrow.type.partial"));
        this.dataStyleBox = new JList<MarkerItem>(dataStyles);
        this.dataStyleBox.setSelectionMode(1);
        this.dataStyleBox.addListSelectionListener(this);
        this.dataStyleBox.setCellRenderer(new MarkerItem());
        JScrollPane jScrollPane3 = new JScrollPane(this.dataStyleBox);
        this.markerTabPane.addTab(JDRResources.getString("arrow.tab.data") + " ", null, jScrollPane3, JDRResources.getString("tooltip.arrow.type.data"));
        this.bracketStyleBox = new JList<MarkerItem>(bracketStyles);
        this.bracketStyleBox.setSelectionMode(1);
        this.bracketStyleBox.addListSelectionListener(this);
        this.bracketStyleBox.setCellRenderer(new MarkerItem());
        JScrollPane jScrollPane4 = new JScrollPane(this.bracketStyleBox);
        this.markerTabPane.addTab(JDRResources.getString("arrow.tab.bracket") + " ", null, jScrollPane4, JDRResources.getString("tooltip.arrow.type.bracket"));
        this.shapesStyleBox = new JList<MarkerItem>(shapesStyles);
        this.shapesStyleBox.setSelectionMode(1);
        this.shapesStyleBox.addListSelectionListener(this);
        this.shapesStyleBox.setCellRenderer(new MarkerItem());
        JScrollPane jScrollPane5 = new JScrollPane(this.shapesStyleBox);
        this.markerTabPane.addTab(JDRResources.getString("arrow.tab.decorative") + " ", null, jScrollPane5, JDRResources.getString("tooltip.arrow.type.decorative"));
        this.capStyleBox = new JList<MarkerItem>(capStyles);
        this.capStyleBox.setSelectionMode(1);
        this.capStyleBox.addListSelectionListener(this);
        this.capStyleBox.setCellRenderer(new MarkerItem());
        JScrollPane jScrollPane6 = new JScrollPane(this.capStyleBox);
        this.markerTabPane.addTab(JDRResources.getString("arrow.tab.caps") + " ", null, jScrollPane6, JDRResources.getString("tooltip.arrow.type.caps"));
        jPanel.add(this.markerTabPane);
        this.add((Component)jPanel, "Left");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(3));
        jPanel2.add(jPanel3);
        this.arrowSize = new NonNegativeLengthPanel(JDRResources.getString("size.label") + " ", JDRResources.getChar("size.mnemonic"), this.selector_.getSamplePathPanel());
        this.arrowSize.setEnabled(false);
        this.arrowSize.setValue(5.0);
        jPanel3.add(this.arrowSize);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.arrowSingle = new JRadioButton(JDRResources.getString("arrow.single") + " ", true);
        this.arrowSingle.setMnemonic(JDRResources.getChar("arrow.single.mnemonic"));
        this.arrowSingle.addActionListener(this);
        this.arrowSingle.setEnabled(false);
        jPanel3.add(this.arrowSingle);
        buttonGroup2.add(this.arrowSingle);
        this.arrowDouble = new JRadioButton(JDRResources.getString("arrow.double") + " ");
        this.arrowDouble.setMnemonic(JDRResources.getChar("arrow.double.mnemonic"));
        this.arrowDouble.addActionListener(this);
        this.arrowDouble.setEnabled(false);
        jPanel3.add(this.arrowDouble);
        buttonGroup2.add(this.arrowDouble);
        this.arrowTriple = new JRadioButton(JDRResources.getString("arrow.triple") + " ");
        this.arrowTriple.setMnemonic(JDRResources.getChar("arrow.triple.mnemonic"));
        this.arrowTriple.addActionListener(this);
        this.arrowTriple.setEnabled(false);
        jPanel3.add(this.arrowTriple);
        buttonGroup2.add(this.arrowTriple);
        this.arrowReverse = new JCheckBox(JDRResources.getString("arrow.reversed") + " ");
        this.arrowReverse.setMnemonic(JDRResources.getChar("arrow.reversed.mnemonic"));
        this.arrowReverse.addActionListener(this);
        this.arrowReverse.setEnabled(false);
        jPanel3.add(this.arrowReverse);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(3));
        jPanel2.add(jPanel4);
        this.autoOrient = new JCheckBox(JDRResources.getString("arrow.autoorient") + " ", true);
        this.autoOrient.setMnemonic(JDRResources.getChar("arrow.autoorient.mnemonic"));
        this.autoOrient.setToolTipText(JDRResources.getString("tooltip.arrow.autoorient"));
        jPanel4.add(this.autoOrient);
        this.autoOrient.addActionListener(this);
        this.angleField = new DoubleField(0.0);
        jPanel4.add(this.angleField);
        this.angleField.getDocument().addDocumentListener(new TextFieldSampleListener(this.selector_.getSamplePathPanel()));
        this.angleField.setToolTipText(JDRResources.getString("tooltip.arrow.angle"));
        this.autoOrient.setEnabled(false);
        this.angleField.setEnabled(false);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(3));
        jPanel2.add(jPanel5);
        this.autoOffset = new JCheckBox(JDRResources.getString("arrow.autooffset") + " ", true);
        this.autoOffset.setMnemonic(JDRResources.getChar("arrow.autooffset.mnemonic"));
        this.autoOffset.setToolTipText(JDRResources.getString("tooltip.arrow.autooffset"));
        jPanel5.add(this.autoOffset);
        this.autoOffset.addActionListener(this);
        this.offsetField = new LengthPanel(this.selector_.getSamplePathPanel());
        jPanel5.add(this.offsetField);
        this.offsetField.setToolTipText(JDRResources.getString("tooltip.arrow.offset"));
        this.autoOffset.setEnabled(false);
        this.offsetField.setEnabled(false);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(3));
        jPanel2.add(jPanel6);
        this.autoGap = new JCheckBox(JDRResources.getString("arrow.autogap") + " ", true);
        this.autoGap.setMnemonic(JDRResources.getChar("arrow.autogap.mnemonic"));
        this.autoGap.setToolTipText(JDRResources.getString("tooltip.arrow.autogap"));
        jPanel6.add(this.autoGap);
        this.autoGap.addActionListener(this);
        this.gapField = new LengthPanel(this.selector_.getSamplePathPanel());
        jPanel6.add(this.gapField);
        this.gapField.setToolTipText(JDRResources.getString("tooltip.arrow.gap"));
        this.autoGap.setEnabled(false);
        this.gapField.setEnabled(false);
        JPanel jPanel7 = new JPanel(new FlowLayout(3));
        jPanel2.add(jPanel7);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.asLineButton = new JRadioButton(JDRResources.getString("arrow.colour.dependent") + " ", true);
        this.asLineButton.addActionListener(this);
        this.asLineButton.setToolTipText(JDRResources.getString("tooltip.arrow.colour.dependent"));
        jPanel7.add(this.asLineButton);
        buttonGroup3.add(this.asLineButton);
        this.notAsLineButton = new JRadioButton(JDRResources.getString("arrow.colour.independent") + " ");
        this.notAsLineButton.addActionListener(this);
        this.notAsLineButton.setToolTipText(JDRResources.getString("tooltip.arrow.colour.independent"));
        jPanel7.add(this.notAsLineButton);
        buttonGroup3.add(this.notAsLineButton);
        this.colourPanel = new ColorPanel();
        this.colourPanel.setMnemonics(JDRResources.getChar("colour.rgb.mnemonic"), JDRResources.getChar("colour.cmyk.mnemonic"));
        jPanel2.add(this.colourPanel);
        this.add((Component)jPanel2, "Center");
        this.setEnabled(true);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.enableMarkerSettings();
        this.selector_.repaintSample();
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.colourPanel.addAdjustmentListener(adjustmentListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.arrowStyleBox.addListSelectionListener(listSelectionListener);
        this.partialStyleBox.addListSelectionListener(listSelectionListener);
        this.dataStyleBox.addListSelectionListener(listSelectionListener);
        this.bracketStyleBox.addListSelectionListener(listSelectionListener);
        this.shapesStyleBox.addListSelectionListener(listSelectionListener);
        this.capStyleBox.addListSelectionListener(listSelectionListener);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.selector_.repaintSample();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.autoOrient) {
            this.enableAngleBoxes();
            if (!this.autoOrient.isSelected()) {
                this.angleField.requestFocusInWindow();
            }
        } else if (object == this.autoOffset) {
            this.enableOffsetBoxes();
            if (!this.autoOffset.isSelected()) {
                this.offsetField.requestFocusInWindow();
            }
        } else if (object == this.autoGap) {
            this.enableGapBoxes();
            if (!this.autoGap.isSelected()) {
                this.gapField.requestFocusInWindow();
            }
        } else if (object == this.arrowSingle) {
            this.autoGap.setEnabled(false);
            this.enableGapBoxes();
        } else if (object == this.arrowDouble || object == this.arrowTriple) {
            int n = this.getArrowStyle();
            boolean bl = n == 0;
            this.autoGap.setEnabled(!bl);
            this.enableGapBoxes();
        } else if (object == this.asLineButton) {
            this.colourPanel.setEnabled(false);
        } else if (object == this.notAsLineButton) {
            this.colourPanel.setEnabled(true);
        } else if (object == this.noMarkerButton) {
            this.enableMarkerBoxes(false);
            this.enableMarkerSettings();
        } else if (object == this.useMarkerButton) {
            this.enableMarkerBoxes(true);
            this.enableMarkerSettings();
            this.getSelectedList().requestFocusInWindow();
        }
        this.selector_.repaintSample();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableMarkerSettings();
        this.selector_.repaintSample();
    }

    public void enableMarkerSettings() {
        MarkerItem markerItem = this.getSelectedMarker();
        boolean bl = markerItem.getType() == 0;
        boolean bl2 = markerItem.isResizable();
        this.arrowStylePanel.updatePanel();
        this.enableMarkerBoxes();
        if (this.arrowSize == null) {
            return;
        }
        this.arrowSize.setEnabled(bl2);
        this.arrowSingle.setEnabled(!bl);
        this.arrowDouble.setEnabled(!bl);
        this.arrowTriple.setEnabled(!bl);
        this.arrowReverse.setEnabled(!bl);
        this.autoOrient.setEnabled(!bl);
        this.enableAngleBoxes();
        this.autoOffset.setEnabled(!bl);
        this.enableOffsetBoxes();
        this.autoGap.setEnabled(!bl && !this.arrowSingle.isSelected());
        this.enableGapBoxes();
        this.asLineButton.setEnabled(!bl);
        this.notAsLineButton.setEnabled(!bl);
        this.colourPanel.setEnabled(!bl && this.notAsLineButton.isSelected());
    }

    private void colourButtonsSetEnabled(boolean bl) {
        this.asLineButton.setEnabled(bl);
        this.notAsLineButton.setEnabled(bl);
        this.colourPanel.setEnabled(bl && this.notAsLineButton.isSelected());
    }

    @Override
    public void setEnabled(boolean bl) {
        MarkerItem markerItem = this.getSelectedMarker();
        int n = markerItem == null ? 0 : markerItem.getType();
        boolean bl2 = n == 0;
        boolean bl3 = markerItem == null ? false : markerItem.isResizable();
        this.useMarkerButton.setEnabled(bl);
        this.noMarkerButton.setEnabled(bl);
        this.enableMarkerBoxes(bl);
        this.arrowSize.setEnabled(bl && bl3);
        this.arrowSingle.setEnabled(bl && !bl2);
        this.arrowDouble.setEnabled(bl && !bl2);
        this.arrowTriple.setEnabled(bl && !bl2);
        this.arrowReverse.setEnabled(bl && !bl2);
        this.autoOrient.setEnabled(bl && !bl2);
        this.enableAngleBoxes();
        this.asLineButton.setEnabled(!bl2);
        this.notAsLineButton.setEnabled(!bl2);
        this.colourPanel.setEnabled(!bl2 && this.notAsLineButton.isSelected());
    }

    private void enableMarkerBoxes() {
        this.enableMarkerBoxes(true);
    }

    private void enableMarkerBoxes(boolean bl) {
        JScrollPane jScrollPane = (JScrollPane)this.markerTabPane.getSelectedComponent();
        if (!bl) {
            jScrollPane.getViewport().getView().setEnabled(bl);
            jScrollPane.setEnabled(bl);
            this.markerTabPane.setEnabled(bl);
        }
        boolean bl2 = this.useMarkerButton.isSelected();
        JList jList = this.getSelectedList(jScrollPane);
        jList.setEnabled(bl2);
        jScrollPane.setEnabled(bl2);
        this.markerTabPane.setEnabled(bl2);
        if (bl2 && jList.getSelectedIndex() == -1) {
            jList.setSelectedIndex(0);
        }
    }

    private void enableAngleBoxes() {
        if (!this.autoOrient.isEnabled()) {
            this.angleField.setEnabled(false);
            return;
        }
        boolean bl = this.autoOrient.isSelected();
        this.angleField.setEnabled(!bl);
    }

    private void enableOffsetBoxes() {
        if (!this.autoOffset.isEnabled()) {
            this.offsetField.setEnabled(false);
            return;
        }
        boolean bl = this.autoOffset.isSelected();
        this.offsetField.setEnabled(!bl);
    }

    private void enableGapBoxes() {
        if (!this.autoGap.isEnabled()) {
            this.gapField.setEnabled(false);
            return;
        }
        boolean bl = this.autoGap.isSelected();
        this.gapField.setEnabled(!bl);
    }

    public void setArrowColour(JDRPaint jDRPaint) {
        if (jDRPaint == null) {
            this.asLineButton.setSelected(true);
            this.colourPanel.setPaint(this.selector_.getLinePaint());
            this.colourPanel.setEnabled(false);
        } else {
            this.notAsLineButton.setSelected(true);
            this.colourPanel.setPaint(jDRPaint);
            this.colourPanel.setEnabled(true);
        }
    }

    public JDRPaint getArrowColour() {
        if (this.asLineButton.isSelected()) {
            return null;
        }
        return this.colourPanel.getPaint();
    }

    public JList getSelectedList(JScrollPane jScrollPane) {
        return (JList)jScrollPane.getViewport().getView();
    }

    public JList getSelectedList() {
        return this.getSelectedList((JScrollPane)this.markerTabPane.getSelectedComponent());
    }

    public MarkerItem getSelectedMarker() {
        if (this.noMarkerButton.isSelected()) {
            return noMarkerItem;
        }
        JList jList = this.getSelectedList();
        MarkerItem markerItem = (MarkerItem)jList.getSelectedValue();
        if (markerItem == null) {
            jList.setSelectedIndex(0);
            markerItem = (MarkerItem)jList.getSelectedValue();
        }
        return markerItem;
    }

    public int getArrowStyle() {
        MarkerItem markerItem = this.getSelectedMarker();
        if (markerItem == null) {
            return 0;
        }
        return markerItem.getType();
    }

    public void setArrowStyle(int n) {
        MarkerItem markerItem;
        int n2;
        if (n == 0) {
            this.noMarkerButton.setSelected(true);
            this.enableMarkerSettings();
            return;
        }
        this.useMarkerButton.setSelected(true);
        this.enableMarkerSettings();
        for (n2 = 0; n2 < arrowStyles.length; ++n2) {
            markerItem = arrowStyles[n2];
            if (markerItem.getType() != n) continue;
            this.arrowStyleBox.setSelectedIndex(n2);
            this.markerTabPane.setSelectedIndex(0);
            return;
        }
        for (n2 = 0; n2 < partialStyles.length; ++n2) {
            markerItem = partialStyles[n2];
            if (markerItem.getType() != n) continue;
            this.partialStyleBox.setSelectedIndex(n2);
            this.markerTabPane.setSelectedIndex(1);
            return;
        }
        for (n2 = 0; n2 < dataStyles.length; ++n2) {
            markerItem = dataStyles[n2];
            if (markerItem.getType() != n) continue;
            this.dataStyleBox.setSelectedIndex(n2);
            this.markerTabPane.setSelectedIndex(2);
            return;
        }
        for (n2 = 0; n2 < bracketStyles.length; ++n2) {
            markerItem = bracketStyles[n2];
            if (markerItem.getType() != n) continue;
            this.bracketStyleBox.setSelectedIndex(n2);
            this.markerTabPane.setSelectedIndex(3);
            return;
        }
        for (n2 = 0; n2 < shapesStyles.length; ++n2) {
            markerItem = shapesStyles[n2];
            if (markerItem.getType() != n) continue;
            this.shapesStyleBox.setSelectedIndex(n2);
            this.markerTabPane.setSelectedIndex(4);
            return;
        }
        for (n2 = 0; n2 < capStyles.length; ++n2) {
            markerItem = capStyles[n2];
            if (markerItem.getType() != n) continue;
            this.capStyleBox.setSelectedIndex(n2);
            this.markerTabPane.setSelectedIndex(5);
            return;
        }
    }

    public double getArrowSize() {
        return this.arrowSize.getValue();
    }

    public int getArrowRepeated() {
        if (this.arrowDouble.isSelected()) {
            return 2;
        }
        if (this.arrowTriple.isSelected()) {
            return 3;
        }
        return 1;
    }

    public void setArrowRepeated(int n) {
        if (n == 3) {
            this.arrowTriple.setSelected(true);
        } else if (n == 2) {
            this.arrowDouble.setSelected(true);
        } else {
            this.arrowSingle.setSelected(true);
        }
    }

    public boolean getArrowReverse() {
        return this.arrowReverse.isSelected();
    }

    public void setArrowReverse(boolean bl) {
        this.arrowReverse.setSelected(bl);
    }

    public void setArrowSize(double d) {
        this.arrowSize.setValue(d);
    }

    public JDRMarker getMarker() {
        JDRMarker jDRMarker = null;
        try {
            jDRMarker = JDRMarker.getPredefinedMarker(this.getArrowStyle(), 1.0, this.getArrowRepeated(), this.getArrowReverse(), this.getArrowSize());
            jDRMarker.fillPaint = this.getArrowColour();
            if (!this.autoOrient.isSelected()) {
                jDRMarker.setOrient(false, Math.toRadians(this.angleField.getValue()));
            }
            if (!this.autoOffset.isSelected()) {
                jDRMarker.enableUserOffset(true);
                jDRMarker.setOffset(this.offsetField.getValue());
            }
            if (!this.autoGap.isSelected()) {
                jDRMarker.enableUserRepeatOffset(true);
                jDRMarker.setRepeatOffset(this.gapField.getValue());
            }
        }
        catch (InvalidMarkerTypeException invalidMarkerTypeException) {
            JDRResources.internalError((Component)this.selector_, invalidMarkerTypeException);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            JDRResources.internalError((Component)this.selector_, invalidRepeatValueException);
        }
        return jDRMarker;
    }

    public void setMarker(JDRMarker jDRMarker) {
        boolean bl;
        boolean bl2;
        boolean bl3 = jDRMarker.getType() == 0;
        this.setArrowStyle(jDRMarker.getType());
        this.setArrowRepeated(jDRMarker.getRepeated());
        this.setArrowReverse(jDRMarker.isReversed());
        if (jDRMarker.isResizable()) {
            this.setArrowSize(jDRMarker.getSize());
        }
        this.setArrowColour(jDRMarker.fillPaint);
        this.arrowSize.setEnabled(jDRMarker.isResizable());
        this.arrowSingle.setEnabled(!bl3);
        this.arrowDouble.setEnabled(!bl3);
        this.arrowTriple.setEnabled(!bl3);
        this.arrowReverse.setEnabled(!bl3);
        boolean bl4 = jDRMarker.getAutoOrient();
        this.autoOrient.setSelected(bl4);
        this.autoOrient.setEnabled(!bl3);
        this.enableAngleBoxes();
        if (!bl4) {
            this.angleField.setValue(Math.toDegrees(jDRMarker.getAngle()));
        }
        this.autoOffset.setSelected(!(bl2 = jDRMarker.isUserOffsetEnabled()));
        this.autoOffset.setEnabled(!bl3);
        this.enableOffsetBoxes();
        if (bl2) {
            this.offsetField.setValue(jDRMarker.getOffset());
        }
        this.autoGap.setSelected(!(bl = jDRMarker.isUserRepeatOffsetEnabled()));
        this.autoGap.setEnabled(!bl3 && !this.arrowSingle.isSelected());
        this.enableGapBoxes();
        if (bl) {
            this.gapField.setValue(jDRMarker.getRepeatOffset());
        }
    }

    public String getDescription() {
        MarkerItem markerItem = this.getSelectedMarker();
        String string = markerItem.getLabel();
        if (markerItem.getType() == 0) {
            return string;
        }
        if (markerItem.isResizable()) {
            string = string + " " + this.getArrowSize();
        }
        if (this.getArrowRepeated() == 2) {
            string = string + " " + JDRResources.getString("arrow.double");
        } else if (this.getArrowRepeated() == 3) {
            string = string + " " + JDRResources.getString("arrow.triple");
        }
        if (this.getArrowReverse()) {
            string = string + " " + JDRResources.getString("arrow.reversed");
        }
        return string;
    }
}

