/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import uk.ac.uea.cmp.nlct.jdr.InvalidMarkerTypeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;

class MarkerItem
implements ListCellRenderer {
    private int type;
    private String label;
    private Icon ic = null;
    private Icon disabledIc = null;
    private JLabel iconComp = null;
    private JLabel textComp = null;
    private JPanel panel = null;
    private boolean resizable = false;
    private boolean cellHasFocus = false;
    private static Color disabledBackground = Color.lightGray;
    private static Color disabledForeground = Color.gray;

    public MarkerItem(int n, String string, double d) {
        this(n, string, d, 24);
    }

    public MarkerItem(int n, String string, double d, int n2) {
        this.type = n;
        this.label = string;
        try {
            JDRMarker jDRMarker = JDRMarker.getPredefinedMarker(n, d, 1, false, 5.0);
            this.resizable = jDRMarker.isResizable();
            if (this.type != 0) {
                GeneralPath generalPath = jDRMarker.getGeneralPath();
                Rectangle rectangle = generalPath.getBounds();
                BufferedImage bufferedImage = new BufferedImage(n2, (int)rectangle.getHeight(), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                renderingHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
                double d2 = 0.5 * rectangle.getHeight();
                graphics2D.setRenderingHints(renderingHints);
                graphics2D.translate(-rectangle.getX(), d2);
                graphics2D.setPaint(Color.black);
                graphics2D.fill(generalPath);
                graphics2D.dispose();
                this.ic = new ImageIcon(bufferedImage);
                bufferedImage = new BufferedImage(n2, (int)rectangle.getHeight(), 2);
                generalPath = jDRMarker.getGeneralPath();
                graphics2D = bufferedImage.createGraphics();
                graphics2D.translate(-rectangle.getX(), d2);
                graphics2D.setPaint(disabledForeground);
                graphics2D.fill(generalPath);
                graphics2D.dispose();
                this.disabledIc = new ImageIcon(bufferedImage);
            }
        }
        catch (InvalidMarkerTypeException invalidMarkerTypeException) {
            JDRResources.internalError(null, JDRResources.getString("error.invalid_arrow_type"), invalidMarkerTypeException);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
    }

    public MarkerItem(int n, String string) {
        this(n, string, 1.0);
    }

    public MarkerItem() {
        this.type = 0;
        this.label = "";
        this.panel = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (MarkerItem.this.cellHasFocus) {
                    Rectangle rectangle = this.getBounds();
                    int n = (int)rectangle.getWidth();
                    int n2 = (int)rectangle.getHeight();
                    rectangle.setBounds(1, 1, n - 2, n2 - 2);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Paint paint = graphics2D.getPaint();
                    graphics2D.setPaint(Color.darkGray);
                    graphics2D.draw(rectangle);
                    graphics2D.setPaint(paint);
                }
            }
        };
        this.panel.setLayout(new FlowLayout(3));
        this.iconComp = new JLabel();
        this.textComp = new JLabel();
        this.textComp.setOpaque(false);
        this.iconComp.setOpaque(false);
        this.panel.add(this.iconComp);
        this.panel.add(this.textComp);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        MarkerItem markerItem = (MarkerItem)object;
        this.textComp.setText(markerItem.getLabel() + " ");
        if (!jList.isEnabled()) {
            this.panel.setBackground(disabledBackground);
            this.panel.setForeground(disabledForeground);
            this.iconComp.setIcon(markerItem.disabledIc);
        } else if (bl) {
            this.panel.setBackground(jList.getSelectionBackground());
            this.panel.setForeground(jList.getSelectionForeground());
            this.iconComp.setIcon(markerItem.ic);
        } else {
            this.panel.setBackground(jList.getBackground());
            this.panel.setForeground(jList.getForeground());
            this.iconComp.setIcon(markerItem.ic);
        }
        this.cellHasFocus = bl2;
        this.panel.setEnabled(jList.isEnabled());
        this.panel.setFont(jList.getFont());
        this.panel.setOpaque(true);
        return this.panel;
    }

    public int getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public String toString() {
        return "MarkerItem [type=" + this.type + ", label=" + this.label + "]";
    }
}

