/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.uea.cmp.nlct.jdr.JDRGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdr.JDRRadialGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRRectangularGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.CoordPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.RadialCoordPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.RectangularCoordPanel;

public class LocationPane
extends JTabbedPane
implements ChangeListener {
    private RectangularCoordPanel rectCoordPanel = new RectangularCoordPanel();
    private RadialCoordPanel radialCoordPanel;
    private JDRGrid grid;
    private JDRPaper paper;
    private JDRUnit unit;
    private static final int RECTANGULAR = 0;
    private static final int RADIAL = 1;
    private int current = 0;

    public LocationPane() {
        this.add((Component)this.rectCoordPanel, 0);
        this.setMnemonicAt(0, JDRResources.getChar("grid.rectangular.mnemonic"));
        this.radialCoordPanel = new RadialCoordPanel();
        this.add((Component)this.radialCoordPanel, 1);
        this.setMnemonicAt(1, JDRResources.getChar("grid.radial.mnemonic"));
        this.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.current;
        this.current = this.getSelectedIndex();
        if (this.current != n) {
            CoordPanel coordPanel = (CoordPanel)((Object)this.getComponentAt(n));
            double d = coordPanel.getXCoord();
            double d2 = coordPanel.getYCoord();
            coordPanel = (CoordPanel)((Object)this.getComponentAt(this.current));
            coordPanel.setCoords(d, d2, this.unit, this.paper);
        }
    }

    public void setCoords(double d, double d2, JDRUnit jDRUnit, JDRPaper jDRPaper, JDRGrid jDRGrid) {
        this.grid = jDRGrid;
        this.paper = jDRPaper;
        this.unit = jDRUnit;
        this.rectCoordPanel.setCoords(d, d2, jDRUnit, jDRPaper);
        this.radialCoordPanel.setCoords(d, d2, jDRUnit, jDRPaper);
        if (jDRGrid instanceof JDRRectangularGrid) {
            this.setSelectedComponent(this.rectCoordPanel);
            this.current = 0;
        } else if (jDRGrid instanceof JDRRadialGrid) {
            this.setSelectedComponent(this.radialCoordPanel);
            this.current = 1;
        }
        this.getCoordPanel().requestCoordFocus();
    }

    public double getXCoord() {
        return this.getCoordPanel().getXCoord();
    }

    public double getYCoord() {
        return this.getCoordPanel().getYCoord();
    }

    public CoordPanel getCoordPanel() {
        return (CoordPanel)((Object)this.getSelectedComponent());
    }
}

