/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.LineWidthPanel;

public class LineWidthSelector
extends JDRSelector {
    private LineWidthPanel linewidthPanel;

    public LineWidthSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("linestyle.thickness"), true);
        Dimension dimension = this.getSize();
        dimension.height = 220;
        this.setSize(dimension);
        JpgfDraw.enableHelpOnButton(this.help, "sec:penwidth");
        this.linewidthPanel = new LineWidthPanel(this);
        this.linewidthPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setToMain(this.linewidthPanel);
    }

    @Override
    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        this.setStroke(jDRFrame.getSelectedStroke());
        super.initialise();
    }

    @Override
    public void okay() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        jDRFrame.setSelectedLineWidth(this.getPenWidth());
        super.okay();
    }

    public double getPenWidth() {
        return this.linewidthPanel.getPenWidth();
    }

    @Override
    public JDRBasicStroke getStroke() {
        return this.linewidthPanel.getStroke();
    }

    public void setStroke(JDRBasicStroke jDRBasicStroke) {
        this.linewidthPanel.setStroke(jDRBasicStroke);
    }

    @Override
    public void setDefaults() {
        this.linewidthPanel.setDefaults();
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = "LineWidthSelector:" + string;
        return string2 + super.info();
    }
}

