/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import javax.swing.BorderFactory;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.LineStylePanel;

public class LineStyleSelector
extends JDRSelector {
    private LineStylePanel linestylePanel;

    public LineStyleSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("linestyle.title"), true, false);
        JpgfDraw.enableHelpOnButton(this.help, "sec:linestyle");
        this.linestylePanel = new LineStylePanel(this);
        this.linestylePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setToMain(this.linestylePanel);
        this.pack();
        this.setLocationRelativeTo(jpgfDraw);
    }

    @Override
    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        this.setStroke(jDRFrame.getSelectedStroke());
        super.initialise();
    }

    @Override
    public void okay() {
        int n = this.linestylePanel.getJoinStyle();
        if (n == 0 && this.linestylePanel.getEnteredMitreLimit() < 1.0) {
            JDRResources.error((Component)this, JDRResources.getString("error.invalid_mitre_limit"));
            return;
        }
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        jDRFrame.setSelectedStroke(this.getStroke());
        super.okay();
    }

    @Override
    public JDRBasicStroke getStroke() {
        if (this.linestylePanel == null) {
            return null;
        }
        return this.linestylePanel.getStroke();
    }

    public void setStroke(JDRBasicStroke jDRBasicStroke) {
        this.linestylePanel.setStroke(jDRBasicStroke);
    }

    @Override
    public void setDefaults() {
        this.linestylePanel.setDefaults();
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = "LineStyleSelector:" + string;
        return string2 + super.info();
    }
}

