/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import uk.ac.uea.cmp.nlct.jdr.DashPattern;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.ArrowStyleDialog;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.DashPatternPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JoinStylePanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.LineWidthPanel;

public class LineStylePanel
extends JScrollPane
implements ItemListener,
ActionListener {
    private JComboBox capStyleBox;
    private ArrowStyleDialog startArrowDialog;
    private JLabel startArrowDesc;
    private JButton startArrowButton;
    private ArrowStyleDialog midArrowDialog;
    private JLabel midArrowDesc;
    private JButton midArrowButton;
    private ArrowStyleDialog endArrowDialog;
    private JLabel endArrowDesc;
    private JButton endArrowButton;
    private JComboBox windingRuleBox;
    private JDRSelector selector_;
    private LineWidthPanel lineWidthPanel;
    private DashPatternPanel dashPatternPanel;
    private JoinStylePanel joinStylePanel;

    public LineStylePanel(JDRSelector jDRSelector) {
        this.selector_ = jDRSelector;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.lineWidthPanel = new LineWidthPanel(this.selector_);
        this.lineWidthPanel.setLayout(new FlowLayout(3));
        this.lineWidthPanel.setAlignmentX(0.0f);
        jPanel.add((Component)this.lineWidthPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.dashPatternPanel = new DashPatternPanel(this.selector_);
        this.dashPatternPanel.setAlignmentX(0.0f);
        jPanel.add((Component)this.dashPatternPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel(JDRResources.getString("linestyle.cap") + " ");
        jLabel.setDisplayedMnemonic(JDRResources.getChar("linestyle.cap.mnemonic"));
        jPanel2.add(jLabel);
        String[] stringArray = new String[]{JDRResources.getString("linestyle.cap.butt"), JDRResources.getString("linestyle.cap.round"), JDRResources.getString("linestyle.cap.square")};
        this.capStyleBox = new JComboBox<String>(stringArray);
        jLabel.setLabelFor(this.capStyleBox);
        jPanel2.add(this.capStyleBox);
        this.capStyleBox.addItemListener(this);
        this.joinStylePanel = new JoinStylePanel(this.selector_);
        jPanel2.add(this.joinStylePanel);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        Insets insets = gridBagConstraints.insets;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        JLabel jLabel2 = new JLabel(JDRResources.getString("linestyle.arrow.start") + " ");
        jLabel2.setDisplayedMnemonic(JDRResources.getChar("linestyle.arrow.start.mnemonic"));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.startArrowDesc = new JLabel("None");
        this.startArrowDesc.setOpaque(true);
        this.startArrowDesc.setBackground(Color.white);
        this.startArrowDesc.setBorder(BorderFactory.createLoweredBevelBorder());
        Dimension dimension = this.startArrowDesc.getPreferredSize();
        dimension.width = 250;
        this.startArrowDesc.setPreferredSize(dimension);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.startArrowDesc, gridBagConstraints);
        this.startArrowDialog = new ArrowStyleDialog(this.selector_, 0);
        this.startArrowButton = new JButton(JDRResources.getString("label.select"));
        this.startArrowButton.addActionListener(this);
        jLabel2.setLabelFor(this.startArrowButton);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.startArrowButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        JLabel jLabel3 = new JLabel(JDRResources.getString("linestyle.arrow.mid") + " ");
        jLabel3.setDisplayedMnemonic(JDRResources.getChar("linestyle.arrow.mid.mnemonic"));
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.midArrowDesc = new JLabel("None");
        this.midArrowDesc.setOpaque(true);
        this.midArrowDesc.setBackground(Color.white);
        this.midArrowDesc.setBorder(BorderFactory.createLoweredBevelBorder());
        this.midArrowDesc.setPreferredSize(dimension);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.midArrowDesc, gridBagConstraints);
        this.midArrowDialog = new ArrowStyleDialog(this.selector_, 1);
        this.midArrowButton = new JButton(JDRResources.getString("label.select"));
        this.midArrowButton.addActionListener(this);
        jLabel3.setLabelFor(this.midArrowButton);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.midArrowButton, gridBagConstraints);
        JLabel jLabel4 = new JLabel(JDRResources.getString("linestyle.arrow.end") + " ");
        jLabel4.setDisplayedMnemonic(JDRResources.getChar("linestyle.arrow.end.mnemonic"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        this.endArrowDesc = new JLabel("None");
        this.endArrowDesc.setBackground(Color.white);
        this.endArrowDesc.setOpaque(true);
        this.endArrowDesc.setBackground(Color.white);
        this.endArrowDesc.setBorder(BorderFactory.createLoweredBevelBorder());
        this.endArrowDesc.setPreferredSize(dimension);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.endArrowDesc, gridBagConstraints);
        this.endArrowDialog = new ArrowStyleDialog(this.selector_, 2);
        this.endArrowButton = new JButton(JDRResources.getString("label.select"));
        this.endArrowButton.addActionListener(this);
        jLabel4.setLabelFor(this.endArrowButton);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.endArrowButton, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setAlignmentX(0.0f);
        JLabel jLabel5 = new JLabel(JDRResources.getString("linestyle.winding_rule") + " ");
        jLabel5.setDisplayedMnemonic(JDRResources.getChar("linestyle.winding_rule.mnemonic"));
        jPanel3.add(jLabel5);
        String[] stringArray2 = new String[]{JDRResources.getString("linestyle.winding_rule.eo"), JDRResources.getString("linestyle.winding_rule.nz")};
        this.windingRuleBox = new JComboBox<String>(stringArray2);
        jLabel5.setLabelFor(this.windingRuleBox);
        jPanel3.add(this.windingRuleBox);
        this.windingRuleBox.addItemListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.setViewportView(jPanel);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        this.selector_.repaintSample();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.startArrowButton) {
            this.startArrowDialog.init();
            this.startArrowDesc.setText(this.startArrowDialog.getDescription());
        } else if (object == this.midArrowButton) {
            this.midArrowDialog.init();
            this.midArrowDesc.setText(this.midArrowDialog.getDescription());
        } else if (object == this.endArrowButton) {
            this.endArrowDialog.init();
            this.endArrowDesc.setText(this.endArrowDialog.getDescription());
        }
        this.selector_.repaintSample();
    }

    public JDRBasicStroke getStroke() {
        JDRBasicStroke jDRBasicStroke;
        try {
            jDRBasicStroke = new JDRBasicStroke(this.getPenWidth(), this.getCapStyle(), this.getJoinStyle(), this.getMitreLimit(), this.getDashPattern(), this.getWindingRule());
        }
        catch (InvalidFormatException invalidFormatException) {
            jDRBasicStroke = new JDRBasicStroke();
            JDRResources.internalError((Component)this, invalidFormatException);
        }
        jDRBasicStroke.setStartArrow(this.getStartMarker());
        jDRBasicStroke.setMidArrow(this.getMidMarker());
        jDRBasicStroke.setEndArrow(this.getEndMarker());
        return jDRBasicStroke;
    }

    public void setStroke(JDRBasicStroke jDRBasicStroke) {
        this.setPenWidth(jDRBasicStroke.getPenWidth());
        this.setCapStyle(jDRBasicStroke.getCapStyle());
        this.setJoinStyle(jDRBasicStroke.getJoinStyle());
        this.setMitreLimit(jDRBasicStroke.getMitreLimit());
        this.setDashPattern(jDRBasicStroke.dashPattern);
        this.setStartMarker(jDRBasicStroke.getStartArrow());
        this.startArrowDesc.setText(this.startArrowDialog.getDescription());
        this.setMidMarker(jDRBasicStroke.getMidArrow());
        this.midArrowDesc.setText(this.midArrowDialog.getDescription());
        this.setEndMarker(jDRBasicStroke.getEndArrow());
        this.endArrowDesc.setText(this.endArrowDialog.getDescription());
        this.setWindingRule(jDRBasicStroke.getWindingRule());
    }

    public double getPenWidth() {
        return this.lineWidthPanel.getPenWidth();
    }

    public void setPenWidth(double d) {
        this.lineWidthPanel.setPenWidth(d);
    }

    public int getCapStyle() {
        return this.capStyleBox.getSelectedIndex();
    }

    public int getJoinStyle() {
        return this.joinStylePanel.getJoinStyle();
    }

    public int getWindingRule() {
        return this.windingRuleBox.getSelectedIndex();
    }

    public void setCapStyle(int n) {
        this.capStyleBox.setSelectedIndex(n);
    }

    public void setJoinStyle(int n) {
        this.joinStylePanel.setJoinStyle(n);
    }

    public JDRMarker getStartMarker() {
        return this.startArrowDialog.getMarker();
    }

    public JDRMarker getMidMarker() {
        return this.midArrowDialog.getMarker();
    }

    public JDRMarker getEndMarker() {
        return this.endArrowDialog.getMarker();
    }

    public void setStartMarker(JDRMarker jDRMarker) {
        this.startArrowDialog.setMarker(jDRMarker);
    }

    public void setMidMarker(JDRMarker jDRMarker) {
        this.midArrowDialog.setMarker(jDRMarker);
    }

    public void setEndMarker(JDRMarker jDRMarker) {
        this.endArrowDialog.setMarker(jDRMarker);
    }

    public void setWindingRule(int n) {
        this.windingRuleBox.setSelectedIndex(n);
    }

    protected double getEnteredMitreLimit() {
        return this.joinStylePanel.getEnteredMitreLimit();
    }

    public double getMitreLimit() {
        return this.joinStylePanel.getMitreLimit();
    }

    public void setMitreLimit(double d) {
        this.joinStylePanel.setMitreLimit(d);
    }

    public DashPattern getDashPattern() {
        return this.dashPatternPanel.getDashPattern();
    }

    public void setDashPattern(DashPattern dashPattern) {
        this.dashPatternPanel.setDashPattern(dashPattern);
    }

    public void setDefaults() {
        this.lineWidthPanel.setDefaults();
        this.dashPatternPanel.setDefaults();
        this.setCapStyle(2);
        this.joinStylePanel.setDefaults();
        this.startArrowDialog.setDefaults();
        this.startArrowDesc.setText(this.startArrowDialog.getDescription());
        this.midArrowDialog.setDefaults();
        this.midArrowDesc.setText(this.midArrowDialog.getDescription());
        this.endArrowDialog.setDefaults();
        this.endArrowDesc.setText(this.endArrowDialog.getDescription());
        this.setWindingRule(0);
    }
}

