/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JoinStylePanel;

public class JoinStyleSelector
extends JDRSelector {
    private JoinStylePanel joinStylePanel;

    public JoinStyleSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("linestyle.join"), true);
        Dimension dimension = this.getSize();
        dimension.height = 220;
        this.setSize(dimension);
        JpgfDraw.enableHelpOnButton(this.help, "sec:joinstyle");
        this.joinStylePanel = new JoinStylePanel(this);
        this.joinStylePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setToMain(this.joinStylePanel);
    }

    @Override
    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        this.setStroke(jDRFrame.getSelectedStroke());
        super.initialise();
    }

    @Override
    public void okay() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        int n = this.getJoinStyle();
        if (n == 0) {
            jDRFrame.setSelectedJoinStyle(n, this.getMitreLimit());
        } else {
            jDRFrame.setSelectedJoinStyle(n);
        }
        super.okay();
    }

    public int getJoinStyle() {
        return this.joinStylePanel.getJoinStyle();
    }

    public double getMitreLimit() {
        return this.joinStylePanel.getMitreLimit();
    }

    @Override
    public JDRBasicStroke getStroke() {
        return this.joinStylePanel.getStroke();
    }

    public void setStroke(JDRBasicStroke jDRBasicStroke) {
        this.joinStylePanel.setStroke(jDRBasicStroke);
    }

    @Override
    public void setDefaults() {
        this.joinStylePanel.setDefaults();
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = "JoinStyleSelector:" + string;
        return string2 + super.info();
    }
}

