/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdr.InvalidJoinStyleException;
import uk.ac.uea.cmp.nlct.jdr.InvalidMitreLimitException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.NonNegativeDoubleField;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.TextFieldSampleListener;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class JoinStylePanel
extends JPanel
implements ItemListener {
    private JDRSelector selector_;
    private JComboBox joinStyleBox;
    private JLabel mitreLimitLabel;
    private NonNegativeDoubleField mitreLimitField;

    public JoinStylePanel(JDRSelector jDRSelector) {
        this.selector_ = jDRSelector;
        JLabel jLabel = new JLabel(JDRResources.getString("linestyle.join"));
        this.add(jLabel);
        jLabel.setDisplayedMnemonic(JDRResources.getChar("linestyle.join.mnemonic"));
        String[] stringArray = new String[]{JDRResources.getString("linestyle.join.mitre"), JDRResources.getString("linestyle.join.round"), JDRResources.getString("linestyle.join.bevel")};
        this.joinStyleBox = new JComboBox<String>(stringArray);
        this.add(this.joinStyleBox);
        this.joinStyleBox.addItemListener(this);
        this.mitreLimitLabel = new JLabel(JDRResources.getString("linestyle.mitre_limit"));
        this.mitreLimitLabel.setDisplayedMnemonic(JDRResources.getChar("linestyle.mitre_limit.mnemonic"));
        this.add(this.mitreLimitLabel);
        this.mitreLimitField = new NonNegativeDoubleField(10.0);
        this.mitreLimitLabel.setLabelFor(this.mitreLimitField);
        this.mitreLimitField.getDocument().addDocumentListener(new TextFieldSampleListener(this.selector_.getSamplePathPanel()));
        this.add(this.mitreLimitField);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.joinStyleBox) {
            boolean bl = this.getJoinStyle() == 0;
            this.mitreLimitLabel.setEnabled(bl);
            this.mitreLimitField.setEnabled(bl);
        }
        this.selector_.repaintSample();
    }

    public JDRBasicStroke getStroke() {
        JDRFrame jDRFrame = this.selector_.application_.getCurrentFrame();
        JDRBasicStroke jDRBasicStroke = jDRFrame == null ? new JDRBasicStroke() : (JDRBasicStroke)jDRFrame.getSelectedStroke().clone();
        int n = this.getJoinStyle();
        try {
            jDRBasicStroke.setJoinStyle(n);
        }
        catch (InvalidJoinStyleException invalidJoinStyleException) {
            // empty catch block
        }
        if (n == 0) {
            try {
                jDRBasicStroke.setMitreLimit(this.getMitreLimit());
            }
            catch (InvalidMitreLimitException invalidMitreLimitException) {
                // empty catch block
            }
        }
        return jDRBasicStroke;
    }

    public void setStroke(JDRBasicStroke jDRBasicStroke) {
        int n = jDRBasicStroke.getJoinStyle();
        this.setJoinStyle(n);
        if (n == 0) {
            this.setMitreLimit(jDRBasicStroke.getMitreLimit());
        }
    }

    public int getJoinStyle() {
        return this.joinStyleBox.getSelectedIndex();
    }

    public void setJoinStyle(int n) {
        this.joinStyleBox.setSelectedIndex(n);
    }

    protected double getEnteredMitreLimit() {
        return this.mitreLimitField.getValue();
    }

    public double getMitreLimit() {
        double d = this.mitreLimitField.getValue();
        return d < 1.0 ? 1.0 : d;
    }

    public void setMitreLimit(double d) {
        this.mitreLimitField.setValue(d < 1.0 ? 1.0 : d);
    }

    public void setDefaults() {
        this.setJoinStyle(0);
        this.setMitreLimit(10.0);
    }
}

