/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRGray;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.PercentageField;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.TextFieldSBarListener;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.SingleColourSelector;

public class GreyPanel
extends JPanel
implements AdjustmentListener,
SingleColourSelector {
    private JScrollBar greySB;
    private JScrollBar alphaSB;
    private PercentageField greyText;
    private PercentageField alphaText;
    private JLabel greyLabel;
    private JLabel alphaLabel;

    public GreyPanel() {
        this.initialise();
    }

    public GreyPanel(AdjustmentListener adjustmentListener) {
        this.initialise();
        this.addAdjustmentListener(adjustmentListener);
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.greySB.addAdjustmentListener(adjustmentListener);
        this.alphaSB.addAdjustmentListener(adjustmentListener);
    }

    public void initialise() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, gridBagConstraints);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 100.0;
        gridBagConstraints2.weighty = 100.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        this.greyLabel = new JLabel(JDRResources.getString("colour.grey"), 4);
        jPanel.add((Component)this.greyLabel, gridBagConstraints2);
        this.greySB = new JScrollBar(0, 0, 0, 0, 100);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.gridheight = 1;
        jPanel.add((Component)this.greySB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        this.greyText = new PercentageField(0);
        jPanel.add((Component)this.greyText, gridBagConstraints2);
        this.greyText.getDocument().addDocumentListener(new TextFieldSBarListener(this.greyText, this.greySB));
        this.greySB.setBlockIncrement(10);
        this.greySB.addAdjustmentListener(this);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 1;
        this.alphaLabel = new JLabel(JDRResources.getString("colour.alpha"), 4);
        jPanel.add((Component)this.alphaLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 4;
        this.alphaSB = new JScrollBar(0, 100, 0, 0, 100);
        jPanel.add((Component)this.alphaSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        this.alphaText = new PercentageField(100);
        jPanel.add((Component)this.alphaText, gridBagConstraints2);
        this.alphaText.getDocument().addDocumentListener(new TextFieldSBarListener(this.alphaText, this.alphaSB));
        this.alphaSB.setBlockIncrement(10);
        this.alphaSB.addAdjustmentListener(this);
    }

    @Override
    public boolean requestDefaultColourFocus() {
        return this.greyText.requestFocusInWindow();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.greyText.getValue() != this.greySB.getValue()) {
            this.greyText.setValue(this.greySB.getValue());
        }
        if (this.alphaText.getValue() != this.alphaSB.getValue()) {
            this.alphaText.setValue(this.alphaSB.getValue());
        }
    }

    @Override
    public JDRPaint getPaint() {
        JDRGray jDRGray = null;
        try {
            jDRGray = new JDRGray((float)this.greySB.getValue() / 100.0f, (float)this.alphaSB.getValue() / 100.0f);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return jDRGray;
    }

    @Override
    public void setPaint(JDRPaint jDRPaint) {
        JDRGray jDRGray = jDRPaint.getJDRGray();
        this.greySB.setValue((int)Math.round(jDRGray.getGray() * 100.0));
        this.alphaSB.setValue((int)Math.round(jDRGray.getAlpha() * 100.0));
    }

    @Override
    public void setEnabled(boolean bl) {
        this.greySB.setEnabled(bl);
        this.alphaSB.setEnabled(bl);
        this.greyText.setEnabled(bl);
        this.alphaText.setEnabled(bl);
        this.greyLabel.setEnabled(bl);
        this.alphaLabel.setEnabled(bl);
    }
}

