/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRGradient;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRRadial;
import uk.ac.uea.cmp.nlct.jdr.JDRShading;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.ColorPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.LinearGradientDirectionPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.RadialGradientDirectionPanel;

public class GradientPanel
extends JPanel
implements ActionListener,
AdjustmentListener {
    private JDRSelector selector_;
    private ColorPanel startPanel;
    private ColorPanel endPanel;
    private JDRPaint defaultPaint;
    private JDRPaint oldPaint;
    private LinearGradientDirectionPanel linearDirectionPanel;
    private RadialGradientDirectionPanel radialDirectionPanel;
    private JRadioButton linearButton;
    private JRadioButton radialButton;

    public GradientPanel(JDRSelector jDRSelector) {
        this.oldPaint = this.defaultPaint = new JDRGradient();
        this.selector_ = jDRSelector;
        this.setLayout(new BoxLayout(this, 3));
        JLabel jLabel = new JLabel(JDRResources.getString("colour.start"));
        jLabel.setAlignmentX(0.0f);
        this.add(jLabel);
        this.startPanel = new ColorPanel(this);
        this.startPanel.setMnemonics(JDRResources.getChar("colour.rgb.mnemonic"), JDRResources.getChar("colour.cmyk.mnemonic"));
        this.startPanel.setAlignmentX(0.0f);
        this.add(this.startPanel);
        JLabel jLabel2 = new JLabel(JDRResources.getString("colour.end"));
        jLabel2.setAlignmentX(0.0f);
        this.add(jLabel2);
        this.endPanel = new ColorPanel(this);
        this.endPanel.setMnemonics(JDRResources.getChar("colour.rgb2.mnemonic"), JDRResources.getChar("colour.cmyk2.mnemonic"));
        this.endPanel.setAlignmentX(0.0f);
        this.add(this.endPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setAlignmentX(0.0f);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.linearButton = new JRadioButton(JDRResources.getString("colour.linear"), true);
        this.linearButton.setMnemonic(JDRResources.getChar("colour.linear.mnemonic"));
        this.linearButton.addActionListener(this);
        this.linearButton.setAlignmentX(0.0f);
        this.linearButton.setAlignmentY(0.0f);
        jPanel.add(this.linearButton);
        buttonGroup.add(this.linearButton);
        this.linearDirectionPanel = new LinearGradientDirectionPanel();
        this.linearDirectionPanel.addActionListener(this);
        this.linearDirectionPanel.setAlignmentX(0.0f);
        this.linearDirectionPanel.setAlignmentY(0.0f);
        jPanel.add(this.linearDirectionPanel);
        this.radialButton = new JRadioButton(JDRResources.getString("colour.radial"));
        this.radialButton.setMnemonic(JDRResources.getChar("colour.radial.mnemonic"));
        this.radialButton.addActionListener(this);
        this.radialButton.setAlignmentX(0.0f);
        this.radialButton.setAlignmentY(0.0f);
        jPanel.add(this.radialButton);
        buttonGroup.add(this.radialButton);
        this.radialDirectionPanel = new RadialGradientDirectionPanel();
        this.radialDirectionPanel.setAlignmentX(0.0f);
        this.radialDirectionPanel.setAlignmentY(0.0f);
        jPanel.add(this.radialDirectionPanel);
        this.add(jPanel);
        this.setDefaults();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.linearButton) {
            this.linearDirectionPanel.setEnabled(true);
            this.radialDirectionPanel.setEnabled(false);
        } else if (object == this.radialButton) {
            this.linearDirectionPanel.setEnabled(false);
            this.radialDirectionPanel.setEnabled(true);
        }
        this.selector_.repaintSample();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.selector_.repaintSample();
    }

    public void setPaint(JDRPaint jDRPaint) {
        this.startPanel.setPaint(((JDRShading)((Object)jDRPaint)).getStartColor());
        this.endPanel.setPaint(((JDRShading)((Object)jDRPaint)).getEndColor());
        if (jDRPaint instanceof JDRGradient) {
            this.linearDirectionPanel.setDirection(((JDRGradient)jDRPaint).getDirection());
            this.linearButton.setSelected(true);
            this.linearDirectionPanel.setEnabled(true);
            this.radialDirectionPanel.setEnabled(false);
        } else {
            this.radialDirectionPanel.setDirection(((JDRRadial)jDRPaint).getStartLocation());
            this.radialButton.setSelected(true);
            this.linearDirectionPanel.setEnabled(false);
            this.radialDirectionPanel.setEnabled(true);
        }
    }

    public JDRPaint getPaint() {
        JDRPaint jDRPaint = null;
        JDRPaint jDRPaint2 = this.startPanel.getPaint();
        JDRPaint jDRPaint3 = this.endPanel.getPaint();
        if (this.linearButton.isSelected()) {
            try {
                jDRPaint = new JDRGradient(this.linearDirectionPanel.getDirection(), jDRPaint2, jDRPaint3);
            }
            catch (InvalidFormatException invalidFormatException) {
                JDRResources.internalError((Component)this, invalidFormatException);
                jDRPaint = new JDRGradient();
            }
        } else {
            try {
                jDRPaint = new JDRRadial(this.radialDirectionPanel.getDirection(), jDRPaint2, jDRPaint3);
            }
            catch (InvalidFormatException invalidFormatException) {
                JDRResources.internalError((Component)this, invalidFormatException);
                jDRPaint = new JDRRadial();
            }
        }
        return jDRPaint;
    }

    public void setDefaults() {
        this.setPaint(this.defaultPaint);
        this.selector_.repaint();
    }

    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = string2 + "GradientPanel:" + string;
        string2 = string2 + "old paint: " + this.oldPaint + string;
        return string2 + string;
    }
}

