/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.FontVAnchorPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class FontVAnchorSelector
extends JDRSelector {
    private FontVAnchorPanel anchorPanel;
    private JDRTextual text = null;

    public FontVAnchorSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("font.vanchor"), false, true, true);
        Dimension dimension = this.getSize();
        dimension.height = 220;
        this.setSize(dimension);
        JpgfDraw.enableHelpOnButton(this.help, "sec:fontanchor");
        this.anchorPanel = new FontVAnchorPanel(this);
        this.anchorPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setToMain(this.anchorPanel);
    }

    @Override
    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        if (jDRFrame != null) {
            this.text = jDRFrame.getSelectedFont();
            this.setVAnchor(this.text.getVAlign());
        } else {
            this.setVAnchor(this.application_.getCurrentPGFVAlign());
        }
        super.initialise();
    }

    @Override
    public String getSampleText() {
        if (this.text != null && !this.text.getText().equals("")) {
            return this.text.getText();
        }
        return super.getSampleText();
    }

    @Override
    public void okay() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        jDRFrame.setSelectedValign(this.getValign());
        super.okay();
    }

    public void setVAnchor(int n) {
        this.anchorPanel.setValign(n);
    }

    @Override
    public int getValign() {
        return this.anchorPanel.getValign();
    }

    @Override
    public void setDefaults() {
        this.anchorPanel.setDefaults();
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = "FontVAnchorSelector:" + string;
        string2 = string2 + "text: " + this.text + string;
        return string2 + super.info();
    }
}

