/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFontBase;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.FontSizePanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class FontSizeSelector
extends JDRSelector {
    private FontSizePanel fontPanel;
    private JDRTextual text = null;

    public FontSizeSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("font.size"), false, true);
        Dimension dimension = this.getSize();
        dimension.height = 220;
        this.setSize(dimension);
        JpgfDraw.enableHelpOnButton(this.help, "sec:fontsize");
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        this.fontPanel = new FontSizePanel(this);
        this.fontPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setToMain(this.fontPanel);
    }

    @Override
    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        if (jDRFrame != null) {
            this.text = jDRFrame.getSelectedFont();
            this.setLaTeXFonts(jDRFrame.getLaTeXFonts());
            this.setFontSize(this.text.getFontSize());
            this.setLaTeXFontSize(this.text.getLaTeXSize());
        } else {
            this.setLaTeXFonts(this.application_.getCurrentLaTeXFontBase());
            this.setFontSize(this.application_.getCurrentFontSize());
            this.setLaTeXFontSize(this.application_.getCurrentLaTeXFontSize());
        }
        super.initialise();
    }

    @Override
    public void okay() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        jDRFrame.setSelectedFontSize(this.getFontSize(), this.getLaTeXFontSize());
        super.okay();
    }

    @Override
    public String getSampleText() {
        if (this.text != null && !this.text.getText().equals("")) {
            return this.text.getText();
        }
        return super.getSampleText();
    }

    public void setFontSize(int n) {
        this.fontPanel.setFontSize(n);
    }

    @Override
    public int getFontSize() {
        if (this.fontPanel == null) {
            return 10;
        }
        return this.fontPanel.getFontSize();
    }

    @Override
    public String getFontName() {
        return this.text == null ? "SansSerif" : this.text.getFontFamily();
    }

    @Override
    public int getFontShape() {
        return this.text == null ? 0 : this.text.getFontShape();
    }

    @Override
    public int getFontSeries() {
        return this.text == null ? 0 : this.text.getFontSeries();
    }

    @Override
    public JDRPaint getTextPaint() {
        return this.text == null ? new JDRColor() : this.text.getTextPaint();
    }

    public void setLaTeXFontSize(String string) {
        this.fontPanel.setLaTeXFontSize(string);
    }

    public String getLaTeXFontSize() {
        return this.fontPanel.getLaTeXFontSize();
    }

    public void setLaTeXFonts(LaTeXFontBase laTeXFontBase) {
        this.fontPanel.setLaTeXFonts(laTeXFontBase);
    }

    @Override
    public void setDefaults() {
        this.fontPanel.setDefaults();
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = "FontSizeSelector:" + string;
        string2 = string2 + "text: " + this.text + string;
        return string2 + super.info();
    }
}

