/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFontBase;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.NonNegativeLengthPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class FontSizePanel
extends JPanel
implements DocumentListener {
    private JDRSelector selector_;
    private NonNegativeLengthPanel fontSizePanel;
    private JComboBox latexFontSize;
    private LaTeXFontBase latexFonts_;

    public FontSizePanel(JDRSelector jDRSelector) {
        this.selector_ = jDRSelector;
        this.latexFonts_ = new LaTeXFontBase(10.0);
        JLabel jLabel = new JLabel(JDRResources.getString("font.size"));
        jLabel.setDisplayedMnemonic(JDRResources.getChar("font.size.mnemonic"));
        this.add(jLabel);
        this.fontSizePanel = new NonNegativeLengthPanel(this.selector_.getSampleTextPanel());
        this.fontSizePanel.getDocument().addDocumentListener(this);
        this.fontSizePanel.setValue(this.latexFonts_.getFontSize(4));
        jLabel.setLabelFor(this.fontSizePanel.getTextField());
        this.fontSizePanel.getTextField().setColumns(3);
        this.add(this.fontSizePanel);
        this.latexFontSize = new JComboBox<String>(new String[]{"\\tiny", "\\scriptsize", "\\footnotesize", "\\small", "\\normalsize", "\\large", "\\Large", "\\LARGE", "\\huge", "\\Huge", "\\veryHuge", "\\VeryHuge", "\\VERYHuge"});
        this.latexFontSize.setToolTipText(JDRResources.getString("tooltip.latex_font_size"));
        this.latexFontSize.setEditable(true);
        this.add(this.latexFontSize);
    }

    public void setLaTeXFonts(LaTeXFontBase laTeXFontBase) {
        this.latexFonts_ = laTeXFontBase;
        this.fontSizePanel.setValue(this.latexFonts_.getFontSize(4));
    }

    public void setNormalSize(int n) {
        this.fontSizePanel.setValue(n);
    }

    public void updateLaTeXSize() {
        String string = this.latexFonts_.getLaTeXCmd(this.fontSizePanel.getValue());
        if (this.latexFontSize != null) {
            this.latexFontSize.setSelectedItem(string);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateLaTeXSize();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateLaTeXSize();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateLaTeXSize();
    }

    public int getFontSize() {
        return (int)this.fontSizePanel.getValue();
    }

    public void setFontSize(int n) {
        this.fontSizePanel.setValue(n);
    }

    public void setLaTeXFontSize(String string) {
        this.latexFontSize.setSelectedItem(string);
    }

    public String getLaTeXFontSize() {
        return (String)this.latexFontSize.getSelectedItem();
    }

    public void setDefaults() {
        this.setNormalSize((int)this.latexFonts_.getFontSize(4));
    }
}

