/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.FontShapePanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class FontShapeSelector
extends JDRSelector {
    private FontShapePanel fontPanel;
    private JDRTextual text = null;

    public FontShapeSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("font.shape"), false, true);
        Dimension dimension = this.getSize();
        dimension.height = 220;
        this.setSize(dimension);
        JpgfDraw.enableHelpOnButton(this.help, "sec:fontshape");
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        this.fontPanel = new FontShapePanel(this);
        this.fontPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setToMain(this.fontPanel);
    }

    @Override
    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        if (jDRFrame != null) {
            this.text = jDRFrame.getSelectedFont();
            this.setFontShape(this.text.getFontShape());
            this.setLaTeXFontShape(this.text.getLaTeXShape());
        } else {
            this.setFontShape(this.application_.getCurrentFontShape());
            this.setLaTeXFontShape(this.application_.getCurrentLaTeXFontShape());
        }
        super.initialise();
    }

    @Override
    public void okay() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        jDRFrame.setSelectedFontShape(this.getFontShape(), this.getLaTeXFontShape());
        super.okay();
    }

    @Override
    public String getSampleText() {
        if (this.text != null && !this.text.getText().equals("")) {
            return this.text.getText();
        }
        return super.getSampleText();
    }

    public void setFontShape(int n) {
        this.fontPanel.setFontShape(n);
    }

    @Override
    public int getFontShape() {
        return this.fontPanel.getFontShape();
    }

    @Override
    public int getFontSize() {
        return this.text == null ? 10 : this.text.getFontSize();
    }

    @Override
    public int getFontSeries() {
        return this.text == null ? 0 : this.text.getFontSeries();
    }

    @Override
    public String getFontName() {
        return this.text == null ? "SansSerif" : this.text.getFontFamily();
    }

    @Override
    public JDRPaint getTextPaint() {
        return this.text == null ? new JDRColor() : this.text.getTextPaint();
    }

    public void setLaTeXFontShape(String string) {
        this.fontPanel.setLaTeXFontShape(string);
    }

    public String getLaTeXFontShape() {
        return this.fontPanel.getLaTeXFontShape();
    }

    @Override
    public void setDefaults() {
        this.fontPanel.setDefaults();
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = "FontShapeSelector:" + string;
        string2 = string2 + "text: " + this.text + string;
        return string2 + super.info();
    }
}

