/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class FontShapePanel
extends JPanel
implements ItemListener {
    private JDRSelector selector_;
    private JComboBox fontShape;
    private JComboBox latexFontShape;

    public FontShapePanel(JDRSelector jDRSelector) {
        this.selector_ = jDRSelector;
        JLabel jLabel = new JLabel(JDRResources.getString("font.shape"));
        jLabel.setDisplayedMnemonic(JDRResources.getChar("font.shape.mnemonic"));
        this.add(jLabel);
        this.fontShape = new JComboBox<String>(new String[]{JDRResources.getString("font.shape.upright"), JDRResources.getString("font.shape.italic")});
        jLabel.setLabelFor(this.fontShape);
        this.add(this.fontShape);
        this.fontShape.addItemListener(this);
        this.latexFontShape = new JComboBox<String>(new String[]{"\\upshape", "\\em", "\\itshape", "\\slshape", "\\scshape"});
        this.latexFontShape.setToolTipText(JDRResources.getString("tooltip.latex_font_shape"));
        this.latexFontShape.setEditable(true);
        this.add(this.latexFontShape);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (itemEvent.getStateChange() == 1) {
            if (object == this.fontShape) {
                int n = this.fontShape.getSelectedIndex();
                this.latexFontShape.setSelectedIndex(n);
            }
            this.selector_.repaintSample();
        }
    }

    public void setFontShape(int n) {
        this.fontShape.setSelectedIndex(n);
    }

    public int getFontShape() {
        return this.fontShape.getSelectedIndex();
    }

    public void setLaTeXFontShape(String string) {
        this.latexFontShape.setSelectedItem(string);
    }

    public String getLaTeXFontShape() {
        return (String)this.latexFontShape.getSelectedItem();
    }

    public void setDefaults() {
        this.setFontShape(0);
    }
}

