/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.FontSeriesPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class FontSeriesSelector
extends JDRSelector {
    private FontSeriesPanel fontPanel;
    private JDRTextual text = null;

    public FontSeriesSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("font.series"), false, true);
        Dimension dimension = this.getSize();
        dimension.height = 220;
        this.setSize(dimension);
        JpgfDraw.enableHelpOnButton(this.help, "sec:fontseries");
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        this.fontPanel = new FontSeriesPanel(this);
        this.fontPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setToMain(this.fontPanel);
    }

    @Override
    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        if (jDRFrame != null) {
            this.text = jDRFrame.getSelectedFont();
            this.setFontSeries(this.text.getFontSeries());
            this.setLaTeXFontSeries(this.text.getLaTeXSeries());
        } else {
            this.setFontSeries(this.application_.getCurrentFontSeries());
            this.setLaTeXFontSeries(this.application_.getCurrentLaTeXFontSeries());
        }
        super.initialise();
    }

    @Override
    public void okay() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        jDRFrame.setSelectedFontSeries(this.getFontSeries(), this.getLaTeXFontSeries());
        super.okay();
    }

    @Override
    public String getSampleText() {
        if (this.text != null && !this.text.getText().equals("")) {
            return this.text.getText();
        }
        return super.getSampleText();
    }

    public void setFontSeries(int n) {
        this.fontPanel.setFontSeries(n);
    }

    @Override
    public int getFontSeries() {
        return this.fontPanel.getFontSeries();
    }

    @Override
    public int getFontSize() {
        return this.text == null ? 10 : this.text.getFontSize();
    }

    @Override
    public int getFontShape() {
        return this.text == null ? 0 : this.text.getFontShape();
    }

    @Override
    public String getFontName() {
        return this.text == null ? "SansSerif" : this.text.getFontFamily();
    }

    @Override
    public JDRPaint getTextPaint() {
        return this.text == null ? new JDRColor() : this.text.getTextPaint();
    }

    public void setLaTeXFontSeries(String string) {
        this.fontPanel.setLaTeXFontSeries(string);
    }

    public String getLaTeXFontSeries() {
        return this.fontPanel.getLaTeXFontSeries();
    }

    @Override
    public void setDefaults() {
        this.fontPanel.setDefaults();
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = "FontSeriesSelector:" + string;
        string2 = string2 + "text: " + this.text + string;
        return string2 + super.info();
    }
}

