/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class FontSeriesPanel
extends JPanel
implements ItemListener {
    private JDRSelector selector_;
    private JComboBox fontSeries;
    private JComboBox latexFontSeries;

    public FontSeriesPanel(JDRSelector jDRSelector) {
        this.selector_ = jDRSelector;
        JLabel jLabel = new JLabel(JDRResources.getString("font.series"));
        jLabel.setDisplayedMnemonic(JDRResources.getChar("font.series.mnemonic"));
        this.add(jLabel);
        this.fontSeries = new JComboBox<String>(new String[]{JDRResources.getString("font.series.medium"), JDRResources.getString("font.series.bold")});
        jLabel.setLabelFor(this.fontSeries);
        this.add(this.fontSeries);
        this.fontSeries.addItemListener(this);
        this.latexFontSeries = new JComboBox<String>(new String[]{"\\mdseries", "\\bfseries"});
        this.latexFontSeries.setToolTipText(JDRResources.getString("tooltip.latex_font_series"));
        this.latexFontSeries.setEditable(true);
        this.add(this.latexFontSeries);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (itemEvent.getStateChange() == 1) {
            if (object == this.fontSeries) {
                int n = this.fontSeries.getSelectedIndex();
                this.latexFontSeries.setSelectedIndex(n);
            }
            this.selector_.repaintSample();
        }
    }

    public void setFontSeries(int n) {
        this.fontSeries.setSelectedIndex(n);
    }

    public int getFontSeries() {
        return this.fontSeries.getSelectedIndex();
    }

    public void setLaTeXFontSeries(String string) {
        this.latexFontSeries.setSelectedItem(string);
    }

    public String getLaTeXFontSeries() {
        return (String)this.latexFontSeries.getSelectedItem();
    }

    public void setDefaults() {
        this.setFontSeries(0);
    }
}

