/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRText;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFontBase;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.FontPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class FontSelector
extends JDRSelector {
    private FontPanel fontPanel;
    private JDRTextual textArea = null;

    public FontSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("font.title"), false, true, true);
        JpgfDraw.enableHelpOnButton(this.help, "sec:font");
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        this.fontPanel = new FontPanel(this, this.application_.getFontFamilies());
        this.fontPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setToMain(this.fontPanel);
        this.setDefaults();
    }

    @Override
    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        if (jDRFrame != null) {
            this.textArea = jDRFrame.getSelectedFont();
            this.setLaTeXFonts(jDRFrame.getLaTeXFonts());
            this.setFontName(this.textArea.getFontFamily());
            this.setFontSize(this.textArea.getFontSize());
            this.setFontSeries(this.textArea.getFontSeries());
            this.setFontShape(this.textArea.getFontShape());
            this.setLaTeXFontFamily(this.textArea.getLaTeXFamily());
            this.setLaTeXFontSize(this.textArea.getLaTeXSize());
            this.setLaTeXFontShape(this.textArea.getLaTeXShape());
            this.setLaTeXFontSeries(this.textArea.getLaTeXSeries());
            this.setValign(this.textArea.getVAlign());
            this.setHalign(this.textArea.getHAlign());
        } else {
            this.setLaTeXFonts(this.application_.getCurrentLaTeXFontBase());
            this.setFontName(this.application_.getCurrentFontFamily());
            this.setFontSize(this.application_.getCurrentFontSize());
            this.setFontSeries(this.application_.getCurrentFontSeries());
            this.setFontShape(this.application_.getCurrentFontShape());
            this.setLaTeXFontFamily(this.application_.getCurrentLaTeXFontFamily());
            this.setLaTeXFontSize(this.application_.getCurrentLaTeXFontSize());
            this.setLaTeXFontShape(this.application_.getCurrentLaTeXFontShape());
            this.setLaTeXFontSeries(this.application_.getCurrentLaTeXFontSeries());
            this.setValign(this.application_.getCurrentPGFVAlign());
            this.setHalign(this.application_.getCurrentPGFHAlign());
            this.fontPanel.setLaTeXFonts(jDRFrame.getLaTeXFonts());
        }
        super.initialise();
    }

    @Override
    public void okay() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        Graphics graphics = jDRFrame.getGraphics();
        JDRText jDRText = new JDRText();
        try {
            jDRText.setFont(graphics, this.getFontName(), this.getFontSeries(), this.getFontShape(), this.getFontSize());
            jDRText.setAlign(this.getHalign(), this.getValign());
        }
        catch (InvalidFormatException invalidFormatException) {
            JDRResources.internalError((Component)this, invalidFormatException);
        }
        graphics.dispose();
        jDRText.setLaTeXFont(this.getLaTeXFontFamily(), this.getLaTeXFontSize(), this.getLaTeXFontSeries(), this.getLaTeXFontShape());
        jDRFrame.setSelectedFont(jDRText);
        super.okay();
    }

    @Override
    public String getSampleText() {
        if (this.textArea != null && !this.textArea.getText().equals("")) {
            return this.textArea.getText();
        }
        return super.getSampleText();
    }

    @Override
    public String getFontName() {
        if (this.fontPanel == null) {
            return "Serif";
        }
        return this.fontPanel.getFontName();
    }

    public void setFontName(String string) {
        this.fontPanel.setFontName(string);
    }

    @Override
    public int getFontSize() {
        if (this.fontPanel == null) {
            return 10;
        }
        return this.fontPanel.getFontSize();
    }

    public void setFontSize(int n) {
        this.fontPanel.setFontSize(n);
    }

    @Override
    public int getFontSeries() {
        if (this.fontPanel == null) {
            return 10;
        }
        return this.fontPanel.getFontSeries();
    }

    @Override
    public int getFontShape() {
        if (this.fontPanel == null) {
            return 10;
        }
        return this.fontPanel.getFontShape();
    }

    public String getLaTeXFontFamily() {
        return this.fontPanel.getLaTeXFontFamily();
    }

    public void setLaTeXFontFamily(String string) {
        this.fontPanel.setLaTeXFontFamily(string);
    }

    public void setLaTeXFontSize(String string) {
        this.fontPanel.setLaTeXFontSize(string);
    }

    public void setLaTeXFontShape(String string) {
        this.fontPanel.setLaTeXFontShape(string);
    }

    public void setLaTeXFontSeries(String string) {
        this.fontPanel.setLaTeXFontSeries(string);
    }

    public String getLaTeXFontShape() {
        return this.fontPanel.getLaTeXFontShape();
    }

    public String getLaTeXFontSeries() {
        return this.fontPanel.getLaTeXFontSeries();
    }

    public String getLaTeXFontSize() {
        return this.fontPanel.getLaTeXFontSize();
    }

    public void setFontSeries(int n) {
        this.fontPanel.setFontSeries(n);
    }

    public void setFontShape(int n) {
        this.fontPanel.setFontShape(n);
    }

    @Override
    public int getHalign() {
        if (this.fontPanel == null) {
            return 10;
        }
        return this.fontPanel.getHalign();
    }

    @Override
    public int getValign() {
        if (this.fontPanel == null) {
            return 10;
        }
        return this.fontPanel.getValign();
    }

    public void setHalign(int n) {
        this.fontPanel.setHalign(n);
    }

    public void setValign(int n) {
        this.fontPanel.setValign(n);
    }

    @Override
    public void setDefaults() {
        this.fontPanel.setDefaults();
    }

    public void setLaTeXFonts(LaTeXFontBase laTeXFontBase) {
        this.fontPanel.setLaTeXFonts(laTeXFontBase);
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = "FontSelector:" + string;
        string2 = string2 + "text: " + this.textArea + string;
        return string2 + super.info();
    }
}

