/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFont;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFontBase;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.NonNegativeLengthPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.FontAnchorPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class FontPanel
extends JScrollPane
implements ItemListener,
DocumentListener {
    private String[] fontNames;
    private JComboBox fontNamesBox;
    private JComboBox latexFontFamily;
    public static final int LATEX_RM = 0;
    public static final int LATEX_SF = 1;
    public static final int LATEX_TT = 2;
    private NonNegativeLengthPanel fontSizePanel;
    private JComboBox latexFontSize;
    private JComboBox fontSeries;
    private JComboBox latexFontSeries;
    private JComboBox fontShape;
    private JComboBox latexFontShape;
    private LaTeXFontBase latexFonts_;
    private JDRSelector selector_;
    private FontAnchorPanel pgfPanel;

    public FontPanel(JDRSelector jDRSelector, String[] stringArray) {
        this.selector_ = jDRSelector;
        this.latexFonts_ = new LaTeXFontBase(10.0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        this.fontNames = stringArray;
        JLabel jLabel = new JLabel(JDRResources.getString("font.family") + " ");
        jLabel.setDisplayedMnemonic(JDRResources.getChar("font.family.mnemonic"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.fontNamesBox = new JComboBox<String>(this.fontNames);
        jLabel.setLabelFor(this.fontNamesBox);
        this.fontNamesBox.addItemListener(this);
        this.fontNamesBox.requestFocusInWindow();
        this.fontNamesBox.setToolTipText(JDRResources.getString("tooltip.font_family"));
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.fontNamesBox, gridBagConstraints);
        this.latexFontFamily = new JComboBox<String>(new String[]{"\\rmfamily", "\\sffamily", "\\ttfamily"});
        this.latexFontFamily.setToolTipText(JDRResources.getString("tooltip.latex_font"));
        this.latexFontFamily.setEditable(true);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.latexFontFamily, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        JLabel jLabel2 = new JLabel(JDRResources.getString("font.size") + " ");
        jLabel2.setDisplayedMnemonic(JDRResources.getChar("font.size.mnemonic"));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.fontSizePanel = new NonNegativeLengthPanel(this.selector_.getSampleTextPanel());
        this.fontSizePanel.getDocument().addDocumentListener(this);
        this.fontSizePanel.setValue(this.latexFonts_.getFontSize(4));
        jLabel2.setLabelFor(this.fontSizePanel.getTextField());
        this.fontSizePanel.getTextField().setColumns(3);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.fontSizePanel, gridBagConstraints);
        this.latexFontSize = new JComboBox<String>(new String[]{"\\tiny", "\\scriptsize", "\\footnotesize", "\\small", "\\normalsize", "\\large", "\\Large", "\\LARGE", "\\huge", "\\Huge", "\\veryHuge", "\\VeryHuge", "\\VERYHuge"});
        this.latexFontSize.setToolTipText(JDRResources.getString("tooltip.latex_font_size"));
        this.latexFontSize.setEditable(true);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.latexFontSize, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        JLabel jLabel3 = new JLabel(JDRResources.getString("font.series") + " ");
        jLabel3.setDisplayedMnemonic(JDRResources.getChar("font.series.mnemonic"));
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.fontSeries = new JComboBox<String>(new String[]{JDRResources.getString("font.series.medium"), JDRResources.getString("font.series.bold")});
        jLabel3.setLabelFor(this.fontSeries);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.fontSeries, gridBagConstraints);
        this.fontSeries.addItemListener(this);
        this.latexFontSeries = new JComboBox<String>(new String[]{"\\mdseries", "\\bfseries"});
        this.latexFontSeries.setToolTipText(JDRResources.getString("tooltip.latex_font_series"));
        this.latexFontSeries.setEditable(true);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.latexFontSeries, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        JLabel jLabel4 = new JLabel(JDRResources.getString("font.shape") + " ");
        jLabel4.setDisplayedMnemonic(JDRResources.getChar("font.shape.mnemonic"));
        jPanel.add((Component)jLabel4, gridBagConstraints);
        this.fontShape = new JComboBox<String>(new String[]{JDRResources.getString("font.shape.upright"), JDRResources.getString("font.shape.italic")});
        jLabel4.setLabelFor(this.fontShape);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.fontShape, gridBagConstraints);
        this.fontShape.addItemListener(this);
        this.latexFontShape = new JComboBox<String>(new String[]{"\\upshape", "\\em", "\\itshape", "\\slshape", "\\scshape"});
        this.latexFontShape.setToolTipText(JDRResources.getString("tooltip.latex_font_shape"));
        this.latexFontShape.setEditable(true);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.latexFontShape, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        JTextArea jTextArea = new JTextArea(JDRResources.getString("font.latex_message"), 2, 40);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setOpaque(false);
        jTextArea.setColumns(20);
        jPanel.add((Component)jTextArea, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        this.pgfPanel = new FontAnchorPanel(jDRSelector);
        jPanel.add((Component)this.pgfPanel, gridBagConstraints);
        this.setViewportView(jPanel);
    }

    protected void setLaTeXFonts(LaTeXFontBase laTeXFontBase) {
        this.latexFonts_ = laTeXFontBase;
        this.fontSizePanel.setValue(this.latexFonts_.getFontSize(4));
    }

    public void setNormalSize(int n) {
        this.fontSizePanel.setValue(n);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (itemEvent.getStateChange() == 1) {
            if (object == this.fontNamesBox) {
                String string = this.fontNames[this.fontNamesBox.getSelectedIndex()];
                this.latexFontFamily.setSelectedItem(LaTeXFont.fromJavaFamily(string));
            } else if (object == this.fontSeries) {
                int n = this.fontSeries.getSelectedIndex();
                this.latexFontSeries.setSelectedIndex(n);
            } else if (object == this.fontShape) {
                int n = this.fontShape.getSelectedIndex();
                this.latexFontShape.setSelectedIndex(n);
            }
            this.selector_.repaintSample();
        }
    }

    public void updateLaTeXSize() {
        String string = this.latexFonts_.getLaTeXCmd(this.fontSizePanel.getValue());
        if (this.latexFontSize != null) {
            this.latexFontSize.setSelectedItem(string);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateLaTeXSize();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateLaTeXSize();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateLaTeXSize();
    }

    public String getFontName() {
        return this.fontNames[this.fontNamesBox.getSelectedIndex()];
    }

    public void setFontName(String string) {
        for (int i = 0; i < this.fontNames.length; ++i) {
            if (!this.fontNames[i].equals(string)) continue;
            this.fontNamesBox.setSelectedIndex(i);
            return;
        }
    }

    public int getFontSize() {
        return (int)this.fontSizePanel.getValue();
    }

    public void setFontSize(int n) {
        this.fontSizePanel.setValue(n);
    }

    public int getFontSeries() {
        return this.fontSeries.getSelectedIndex();
    }

    public int getFontShape() {
        return this.fontShape.getSelectedIndex();
    }

    public String getLaTeXFontFamily() {
        return (String)this.latexFontFamily.getSelectedItem();
    }

    public void setLaTeXFontFamily(String string) {
        this.latexFontFamily.setSelectedItem(string);
    }

    public void setLaTeXFontSize(String string) {
        this.latexFontSize.setSelectedItem(string);
    }

    public void setLaTeXFontShape(String string) {
        this.latexFontShape.setSelectedItem(string);
    }

    public void setLaTeXFontSeries(String string) {
        this.latexFontSeries.setSelectedItem(string);
    }

    public void setHalign(int n) {
        this.pgfPanel.setHalign(n);
    }

    public void setValign(int n) {
        this.pgfPanel.setValign(n);
    }

    public int getHalign() {
        return this.pgfPanel.getHalign();
    }

    public int getValign() {
        return this.pgfPanel.getValign();
    }

    public String getLaTeXFontShape() {
        return (String)this.latexFontShape.getSelectedItem();
    }

    public String getLaTeXFontSeries() {
        return (String)this.latexFontSeries.getSelectedItem();
    }

    public String getLaTeXFontSize() {
        return (String)this.latexFontSize.getSelectedItem();
    }

    public void setFontSeries(int n) {
        this.fontSeries.setSelectedIndex(n);
    }

    public void setFontShape(int n) {
        this.fontShape.setSelectedIndex(n);
    }

    public void setDefaults() {
        this.setFontName(JDRResources.getString("font.default"));
        this.setNormalSize((int)this.latexFonts_.getFontSize(4));
        this.setFontSeries(0);
        this.setFontShape(0);
        this.pgfPanel.setDefaults();
    }
}

