/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.FontHAnchorPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class FontHAnchorSelector
extends JDRSelector {
    private FontHAnchorPanel anchorPanel;
    private JDRTextual text = null;

    public FontHAnchorSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("font.hanchor"), false, true, true);
        Dimension dimension = this.getSize();
        dimension.height = 220;
        this.setSize(dimension);
        JpgfDraw.enableHelpOnButton(this.help, "sec:fontanchor");
        JPanel jPanel = new JPanel();
        this.anchorPanel = new FontHAnchorPanel(this);
        this.anchorPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setToMain(this.anchorPanel);
    }

    @Override
    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        if (jDRFrame != null) {
            this.text = jDRFrame.getSelectedFont();
            this.setHAnchor(this.text.getHAlign());
        } else {
            this.setHAnchor(this.application_.getCurrentPGFHAlign());
        }
        super.initialise();
    }

    @Override
    public String getSampleText() {
        if (this.text != null && !this.text.getText().equals("")) {
            return this.text.getText();
        }
        return super.getSampleText();
    }

    @Override
    public void okay() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        jDRFrame.setSelectedHalign(this.getHalign());
        super.okay();
    }

    public void setHAnchor(int n) {
        this.anchorPanel.setHalign(n);
    }

    @Override
    public int getHalign() {
        return this.anchorPanel.getHalign();
    }

    @Override
    public void setDefaults() {
        this.anchorPanel.setDefaults();
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = "FontHAnchorSelector:" + string;
        string2 = string2 + "text: " + this.text + string;
        return string2 + super.info();
    }
}

