/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.FontFamilyPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class FontFamilySelector
extends JDRSelector {
    private FontFamilyPanel fontPanel;
    private JDRTextual text = null;

    public FontFamilySelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("font.family"), false, true);
        Dimension dimension = this.getSize();
        dimension.height = 220;
        this.setSize(dimension);
        JpgfDraw.enableHelpOnButton(this.help, "sec:fontfamily");
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        this.fontPanel = new FontFamilyPanel(this, this.application_.getFontFamilies());
        this.fontPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setToMain(this.fontPanel);
    }

    @Override
    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        if (jDRFrame != null) {
            this.text = jDRFrame.getSelectedFont();
            this.setFontName(this.text.getFontFamily());
            this.setLaTeXFontFamily(this.text.getLaTeXFamily());
        } else {
            this.setFontName(this.application_.getCurrentFontFamily());
            this.setLaTeXFontFamily(this.application_.getCurrentLaTeXFontFamily());
        }
        super.initialise();
    }

    @Override
    public void okay() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        jDRFrame.setSelectedFontFamily(this.getFontName(), this.getLaTeXFontFamily());
        super.okay();
    }

    @Override
    public String getSampleText() {
        if (this.text != null && this.text.getText().length() > 0) {
            return this.text.getText();
        }
        return super.getSampleText();
    }

    public void setFontName(String string) {
        this.fontPanel.setFontName(string);
    }

    @Override
    public String getFontName() {
        return this.fontPanel.getFontName();
    }

    @Override
    public int getFontSize() {
        return this.text == null ? 10 : this.text.getFontSize();
    }

    @Override
    public int getFontShape() {
        return this.text == null ? 0 : this.text.getFontShape();
    }

    @Override
    public int getFontSeries() {
        return this.text == null ? 0 : this.text.getFontSeries();
    }

    @Override
    public JDRPaint getTextPaint() {
        return this.text == null ? new JDRColor() : this.text.getTextPaint();
    }

    public void setLaTeXFontFamily(String string) {
        this.fontPanel.setLaTeXFontFamily(string);
    }

    public String getLaTeXFontFamily() {
        return this.fontPanel.getLaTeXFontFamily();
    }

    @Override
    public void setDefaults() {
        this.fontPanel.setDefaults();
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = "FontFamilySelector:" + string;
        string2 = string2 + "text: " + this.text + string;
        return string2 + super.info();
    }
}

