/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFont;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class FontFamilyPanel
extends JPanel
implements ItemListener {
    private JDRSelector selector_;
    private String[] fontNames;
    private JLabel fontFamilyLabel;
    private JComboBox fontNamesBox;
    private JComboBox latexFontFamily;
    public static final int LATEX_RM = 0;
    public static final int LATEX_SF = 1;
    public static final int LATEX_TT = 2;

    public FontFamilyPanel(JDRSelector jDRSelector, String[] stringArray) {
        this.selector_ = jDRSelector;
        this.fontNames = stringArray;
        JLabel jLabel = new JLabel(JDRResources.getString("font.family") + " ");
        jLabel.setDisplayedMnemonic(JDRResources.getChar("font.family.mnemonic"));
        this.add(jLabel);
        this.fontNamesBox = new JComboBox<String>(this.fontNames);
        jLabel.setLabelFor(this.fontNamesBox);
        this.fontNamesBox.addItemListener(this);
        this.fontNamesBox.requestFocusInWindow();
        this.fontNamesBox.setToolTipText(JDRResources.getString("tooltip.font_family"));
        this.add(this.fontNamesBox);
        this.latexFontFamily = new JComboBox<String>(new String[]{"\\rmfamily", "\\sffamily", "\\ttfamily"});
        this.latexFontFamily.setToolTipText(JDRResources.getString("tooltip.latex_font"));
        this.latexFontFamily.setEditable(true);
        this.add(this.latexFontFamily);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (itemEvent.getStateChange() == 1) {
            if (object == this.fontNamesBox) {
                String string = this.getFontName();
                String string2 = LaTeXFont.fromJavaFamily(string);
                this.latexFontFamily.setSelectedItem(string2);
            }
            this.selector_.repaintSample();
        }
    }

    public String getFontName() {
        return this.fontNames[this.fontNamesBox.getSelectedIndex()];
    }

    public void setFontName(String string) {
        for (int i = 0; i < this.fontNames.length; ++i) {
            if (!this.fontNames[i].equals(string)) continue;
            this.fontNamesBox.setSelectedIndex(i);
            return;
        }
    }

    public String getLaTeXFontFamily() {
        return (String)this.latexFontFamily.getSelectedItem();
    }

    public void setLaTeXFontFamily(String string) {
        this.latexFontFamily.setSelectedItem(string);
    }

    public void setDefaults() {
        this.setFontName(JDRResources.getString("font.default"));
    }
}

