/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;

public class FindByDescriptionDialogBox
extends JDialog
implements ActionListener {
    private JComboBox descriptionBox;
    private DefaultComboBoxModel descriptionModel;
    private JpgfDraw application_;
    private JDRFrame mainPanel = null;
    private JDRGroup paths;
    private boolean deselect_ = true;

    public FindByDescriptionDialogBox(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("findbydescription.title"), true);
        this.application_ = jpgfDraw;
        this.descriptionModel = new DefaultComboBoxModel();
        this.descriptionBox = new JComboBox(this.descriptionModel);
        this.getContentPane().add((Component)this.descriptionBox, "Center");
        JPanel jPanel = new JPanel();
        jPanel.add(JDRResources.createOkayButton(this));
        jPanel.add(JDRResources.createCancelButton(this));
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        Dimension dimension = this.getSize();
        if (dimension.width < 300) {
            dimension.width = 300;
            this.setSize(dimension);
        }
        this.setLocationRelativeTo(jpgfDraw);
    }

    public void initialise(boolean bl) {
        this.mainPanel = this.application_.getCurrentFrame();
        this.descriptionModel.removeAllElements();
        this.paths = this.mainPanel.getAllPaths();
        this.deselect_ = bl;
        int n = this.paths.size();
        for (int i = 0; i < n; ++i) {
            JDRCompleteObject jDRCompleteObject = this.paths.get(i);
            String string = "";
            if (!jDRCompleteObject.description.equals("")) {
                string = jDRCompleteObject.description;
            } else if (jDRCompleteObject.flowframe == null) {
                String string2 = jDRCompleteObject.getClass().getName().toLowerCase().substring(jDRCompleteObject.getClass().getPackage().getName().length() + 4);
                string = JDRResources.getStringWithValue("findbydescription." + string2, jDRCompleteObject.getDescriptionInfo());
            } else {
                switch (jDRCompleteObject.flowframe.getType()) {
                    case 0: {
                        string = string + JDRResources.getString("flowframe.static");
                        break;
                    }
                    case 1: {
                        string = string + JDRResources.getString("flowframe.flow");
                        break;
                    }
                    case 2: {
                        string = string + JDRResources.getString("flowframe.dynamic");
                    }
                }
                string = string + " \"" + jDRCompleteObject.flowframe.label + "\"";
            }
            this.descriptionModel.addElement(string);
        }
        this.descriptionBox.requestFocusInWindow();
        this.setVisible(true);
    }

    public void okay() {
        int n = this.descriptionBox.getSelectedIndex();
        if (this.deselect_) {
            this.mainPanel.deselectAll();
        }
        this.mainPanel.selectObjectAndScroll(this.paths.get(n));
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("okay")) {
            this.okay();
        } else if (string.equals("cancel")) {
            this.setVisible(false);
        }
    }
}

