/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRCanvas;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;

public class FadeDialogBox
extends JDialog
implements ActionListener,
ChangeListener {
    private JpgfDraw application_;
    private JDRCanvas canvas;
    private JSlider slider;
    private JPanel samplePanel;
    private JDRGroup selection;
    private JDRCompleteObject object;
    private double factor;
    private JDRFrame mainPanel = null;

    public FadeDialogBox(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("fade.title"), true);
        this.setSize(300, 110);
        this.application_ = jpgfDraw;
        this.setLocationRelativeTo(this.application_);
        this.slider = new JSlider(0, 0, 100, 100);
        this.slider.addChangeListener(this);
        this.slider.setMajorTickSpacing(10);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.getContentPane().add((Component)this.slider, "North");
        this.samplePanel = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (FadeDialogBox.this.object != null && FadeDialogBox.this.slider.getValue() > 0) {
                    FadeDialogBox.this.object.draw(graphics);
                }
            }
        };
        this.samplePanel.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.samplePanel);
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        this.getContentPane().add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.add(JDRResources.createOkayButton(this));
        jPanel.add(JDRResources.createCancelButton(this));
        jPanel.add(JDRResources.createHelpButton("sec:fade"));
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
    }

    public void display() {
        this.mainPanel = this.application_.getCurrentFrame();
        this.canvas = this.mainPanel.getCanvas();
        this.selection = this.canvas.getSelection();
        this.object = null;
        int n = this.selection.size();
        for (int i = 0; i < n; ++i) {
            JDRCompleteObject jDRCompleteObject = this.selection.get(i);
            if (!jDRCompleteObject.hasShape() && !jDRCompleteObject.hasTextual()) continue;
            this.object = jDRCompleteObject;
            break;
        }
        if (this.object == null) {
            JDRResources.internalError("No selected shape or textual to fade");
            return;
        }
        BBox bBox = this.selection.getBBox();
        this.samplePanel.setPreferredSize(new Dimension((int)Math.ceil(bBox.getMaxX()), (int)Math.ceil(bBox.getMaxY())));
        this.validate();
        this.factor = 1.0;
        this.setVisible(true);
    }

    public void okay() {
        this.canvas.fade(0.01 * (double)this.slider.getValue());
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("okay")) {
            this.okay();
        } else if (string.equals("cancel")) {
            this.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.slider.getValue();
        if (n == 0) {
            return;
        }
        double d = this.factor;
        this.factor = (double)n * 0.01;
        this.selection.fade(this.factor / d);
        this.samplePanel.repaint();
    }

    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = string2 + "FadeDialog:" + string;
        string2 = string2 + "has focus: " + this.hasFocus() + string;
        string2 = string2 + "slider: " + this.slider + string;
        return string2 + string;
    }
}

