/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.uea.cmp.nlct.jdr.FlowFrame;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.MarginPanel;

public class FLFSelector
extends JDialog
implements ActionListener,
ItemListener {
    private JpgfDraw application_;
    private JDRCompleteObject object = null;
    private JComboBox type;
    private JComboBox border;
    private JComboBox pageList;
    private JTextField labelText;
    private JLabel labelLabel;
    private JLabel borderLabel;
    private JLabel pagesLabel;
    private MarginPanel margins;
    public static final int STATIC = 0;
    public static final int FLOW = 1;
    public static final int DYNAMIC = 2;
    public static final int NONE = 3;
    private JComboBox shapeBox;
    private JLabel shapeLabel;
    private JComboBox alignBox;
    private JLabel alignLabel;

    public FLFSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("flowframe.title"), true);
        this.application_ = jpgfDraw;
        int n = 400;
        int n2 = 250;
        this.setSize(n, n2);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n3 = dimension.height;
        int n4 = dimension.width;
        this.setLocation((n4 - n) / 2, (n3 - n2) / 2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(JDRResources.getString("flowframe.type"));
        jLabel.setDisplayedMnemonic(JDRResources.getChar("flowframe.type.mnemonic"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.type = new JComboBox<String>(new String[]{JDRResources.getString("flowframe.static"), JDRResources.getString("flowframe.flow"), JDRResources.getString("flowframe.dynamic"), JDRResources.getString("flowframe.none")});
        this.type.addItemListener(this);
        jLabel.setLabelFor(this.type);
        jPanel.add((Component)this.type, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.labelLabel = new JLabel(JDRResources.getString("flowframe.label"));
        this.labelLabel.setDisplayedMnemonic(JDRResources.getChar("flowframe.label.mnemonic"));
        jPanel.add((Component)this.labelLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.labelText = new JTextField(8);
        this.labelLabel.setLabelFor(this.labelText);
        jPanel.add((Component)this.labelText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.borderLabel = new JLabel(JDRResources.getString("flowframe.border"));
        this.borderLabel.setDisplayedMnemonic(JDRResources.getChar("flowframe.border.mnemonic"));
        jPanel.add((Component)this.borderLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.border = new JComboBox<String>(new String[]{JDRResources.getString("flowframe.border_none"), JDRResources.getString("flowframe.border_as_shown")});
        this.border.setSelectedItem(JDRResources.getString("flowframe.border_as_shown"));
        this.borderLabel.setLabelFor(this.border);
        jPanel.add((Component)this.border, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.pagesLabel = new JLabel(JDRResources.getString("flowframe.pages"));
        this.pagesLabel.setDisplayedMnemonic(JDRResources.getChar("flowframe.pages.mnemonic"));
        jPanel.add((Component)this.pagesLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.pageList = new JComboBox<String>(new String[]{JDRResources.getString("flowframe.pages_all"), JDRResources.getString("flowframe.pages_none"), JDRResources.getString("flowframe.pages_odd"), JDRResources.getString("flowframe.pages_even")});
        this.pageList.setEditable(true);
        this.pagesLabel.setLabelFor(this.pageList);
        jPanel.add((Component)this.pageList, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.shapeLabel = new JLabel(JDRResources.getString("flowframe.shape"));
        this.shapeLabel.setDisplayedMnemonic(JDRResources.getChar("flowframe.shape.mnemonic"));
        jPanel.add((Component)this.shapeLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.shapeBox = new JComboBox<String>(new String[]{JDRResources.getString("flowframe.shape_standard"), JDRResources.getString("flowframe.shape_parshape"), JDRResources.getString("flowframe.shape_shapepar")});
        this.shapeBox.addItemListener(this);
        this.shapeLabel.setLabelFor(this.shapeBox);
        jPanel.add((Component)this.shapeBox, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.alignLabel = new JLabel(JDRResources.getString("flowframe.align"));
        this.alignLabel.setDisplayedMnemonic(JDRResources.getChar("flowframe.align.mnemonic"));
        jPanel.add((Component)this.alignLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.alignBox = new JComboBox<String>(new String[]{JDRResources.getString("flowframe.align_top"), JDRResources.getString("flowframe.align_middle"), JDRResources.getString("flowframe.align_bottom")});
        this.alignLabel.setLabelFor(this.alignBox);
        jPanel.add((Component)this.alignBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        this.margins = new MarginPanel();
        jPanel.add((Component)this.margins, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(JDRResources.createOkayButton(this));
        jPanel2.add(JDRResources.createCancelButton(this));
        jPanel2.add(JDRResources.createHelpButton("sec:framedef"));
        this.getContentPane().add((Component)jPanel2, "South");
    }

    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        this.object = jDRFrame.getSelectedObject();
        if (this.object != null) {
            this.setValues(this.object.flowframe);
        }
        this.setVisible(true);
    }

    public void okay() {
        FlowFrame flowFrame = null;
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        int n = this.type.getSelectedIndex();
        if (n != 3) {
            if (this.labelText.getText().equals("")) {
                JDRResources.error((Component)this, JDRResources.getString("error.no_idl"));
                return;
            }
            if (!jDRFrame.isUniqueLabel(n, this.object, this.labelText.getText())) {
                JDRResources.error((Component)this, JDRResources.getString("error.idl_exists"));
                return;
            }
            String string = (String)this.pageList.getSelectedItem();
            if (string.equals(JDRResources.getString("flowframe.pages_all"))) {
                string = "all";
            } else if (string.equals(JDRResources.getString("flowframe.pages_odd"))) {
                string = "odd";
            } else if (string.equals(JDRResources.getString("flowframe.pages_even"))) {
                string = "even";
            } else if (string.equals(JDRResources.getString("flowframe.pages_none"))) {
                string = "none";
            }
            if (!FlowFrame.isValidPageList(string)) {
                JDRResources.error((Component)this, JDRResources.getString("error.invalid_pagelist"));
                return;
            }
            flowFrame = new FlowFrame(n, this.border.getSelectedIndex() == 1, this.labelText.getText(), string);
            if (this.margins.isEnabled()) {
                flowFrame.left = this.margins.left();
                flowFrame.right = this.margins.right();
                flowFrame.top = this.margins.top();
                flowFrame.bottom = this.margins.bottom();
            } else {
                flowFrame.left = 0.0;
                flowFrame.right = 0.0;
                flowFrame.top = 0.0;
                flowFrame.bottom = 0.0;
            }
            if (n == 0 || n == 2) {
                if (this.object instanceof JDRPath) {
                    try {
                        flowFrame.setShape(this.shapeBox.getSelectedIndex());
                    }
                    catch (InvalidFormatException invalidFormatException) {
                        JDRResources.internalError((Component)this, invalidFormatException);
                        return;
                    }
                }
                try {
                    flowFrame.setVAlign(this.alignBox.getSelectedIndex());
                }
                catch (InvalidFormatException invalidFormatException) {
                    JDRResources.internalError((Component)this, invalidFormatException);
                    return;
                }
            }
        }
        this.setVisible(false);
        if (this.object != null) {
            jDRFrame.setFlowFrame(this.object, flowFrame);
        }
        this.object = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("okay")) {
            this.okay();
        } else if (string.equals("cancel")) {
            this.setVisible(false);
            this.object = null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (itemEvent.getStateChange() == 1) {
            if (object == this.type) {
                int n = this.type.getSelectedIndex();
                boolean bl = n == 0 || n == 2;
                boolean bl2 = bl && this.object instanceof JDRPath;
                this.shapeLabel.setEnabled(bl2);
                this.shapeBox.setEnabled(bl2);
                if (!this.alignBox.isEnabled() && bl) {
                    this.alignBox.setSelectedIndex(n == 0 ? 1 : 0);
                }
                this.alignLabel.setEnabled(bl);
                this.alignBox.setEnabled(bl);
                if (n == 3) {
                    this.border.setEnabled(false);
                    this.borderLabel.setEnabled(false);
                    this.labelText.setEnabled(false);
                    this.labelLabel.setEnabled(false);
                    this.pageList.setEnabled(false);
                    this.pagesLabel.setEnabled(false);
                    this.margins.setEnabled(false);
                } else {
                    this.border.setEnabled(true);
                    this.borderLabel.setEnabled(true);
                    this.labelText.setEnabled(true);
                    this.labelLabel.setEnabled(true);
                    this.pageList.setEnabled(true);
                    this.pagesLabel.setEnabled(true);
                    this.margins.setEnabled(this.shapeBox.getSelectedIndex() == 0 || !bl2);
                }
            } else if (object == this.shapeBox) {
                this.margins.setEnabled(this.shapeBox.getSelectedIndex() == 0);
            }
        }
    }

    public void setValues(FlowFrame flowFrame) {
        if (flowFrame == null) {
            this.type.setSelectedIndex(3);
            this.labelText.setText("");
        } else {
            int n = flowFrame.getType();
            this.type.setSelectedIndex(n);
            this.border.setSelectedIndex(flowFrame.border ? 1 : 0);
            if (flowFrame.pages.equals("all")) {
                this.pageList.setSelectedItem(JDRResources.getString("flowframe.pages_all"));
            } else if (flowFrame.pages.equals("odd")) {
                this.pageList.setSelectedItem(JDRResources.getString("flowframe.pages_odd"));
            } else if (flowFrame.pages.equals("even")) {
                this.pageList.setSelectedItem(JDRResources.getString("flowframe.pages_even"));
            } else if (flowFrame.pages.equals("none")) {
                this.pageList.setSelectedItem(JDRResources.getString("flowframe.pages_none"));
            } else {
                this.pageList.setSelectedItem(flowFrame.pages);
            }
            this.labelText.setText(flowFrame.label);
            this.margins.setMargins(flowFrame.left, flowFrame.right, flowFrame.top, flowFrame.bottom);
            this.shapeBox.setSelectedIndex(flowFrame.getShape());
            this.alignBox.setSelectedIndex(flowFrame.getVAlign());
            boolean bl = n == 0 || n == 2;
            boolean bl2 = bl && this.object instanceof JDRPath;
            this.shapeLabel.setEnabled(bl2);
            this.shapeBox.setEnabled(bl2);
            this.alignLabel.setEnabled(bl);
            this.alignBox.setEnabled(bl);
        }
    }

    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = string2 + "FLFSelector:" + string;
        string2 = string2 + "has focus: " + this.hasFocus() + string;
        string2 = string2 + "type box has focus: " + this.type.hasFocus() + string;
        string2 = string2 + "border box has focus: " + this.border.hasFocus() + string;
        string2 = string2 + "page list box has focus: " + this.pageList.hasFocus() + string;
        string2 = string2 + "label field has focus: " + this.labelText.hasFocus() + string;
        return string2 + string;
    }
}

