/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;

class DirPanel
extends JPanel
implements ActionListener {
    private JRadioButton cwd;
    private JRadioButton lastDir;
    private JRadioButton named;
    private JButton browse;
    private JTextField directory;
    private JFileChooser fc;

    public DirPanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        Box box = Box.createVerticalBox();
        this.cwd = new JRadioButton(JDRResources.getString("startdir.cwd") + " ");
        this.cwd.setMnemonic(JDRResources.getChar("startdir.cwd.mnemonic"));
        this.cwd.setAlignmentX(0.0f);
        buttonGroup.add(this.cwd);
        this.cwd.addActionListener(this);
        box.add(this.cwd);
        this.lastDir = new JRadioButton(JDRResources.getString("startdir.last") + " ");
        this.lastDir.setMnemonic(JDRResources.getChar("startdir.last.mnemonic"));
        this.lastDir.setAlignmentX(0.0f);
        buttonGroup.add(this.lastDir);
        this.lastDir.addActionListener(this);
        box.add(this.lastDir);
        Box box2 = Box.createHorizontalBox();
        box2.setAlignmentX(0.0f);
        this.named = new JRadioButton(JDRResources.getString("startdir.named") + " ");
        this.named.setMnemonic(JDRResources.getChar("startdir.named.mnemonic"));
        buttonGroup.add(this.named);
        this.named.addActionListener(this);
        box2.add(this.named);
        this.directory = new JTextField(10);
        box2.add(this.directory);
        this.browse = new JButton(JDRResources.getString("startdir.browse"));
        this.browse.setMnemonic(JDRResources.getChar("startdir.browse.mnemonic"));
        this.browse.addActionListener(this);
        box2.add(this.browse);
        box.add(box2);
        this.add(box);
        this.fc = new JFileChooser();
        this.fc.setCurrentDirectory(new File("."));
        this.fc.setFileSelectionMode(1);
        this.fc.setApproveButtonText(JDRResources.getString("label.okay"));
        this.fc.setApproveButtonMnemonic(JDRResources.getChar("label.okay.mnemonic"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        if (object == this.cwd || object == this.lastDir) {
            this.directory.setEnabled(false);
            this.browse.setEnabled(false);
        } else if (object == this.named) {
            this.directory.setEnabled(true);
            this.browse.setEnabled(true);
        } else if (object == this.browse && (n = this.fc.showOpenDialog(this)) == 0) {
            this.directory.setText(this.fc.getSelectedFile().getAbsolutePath());
        }
    }

    public void initialise(JpgfDraw jpgfDraw) {
        int n = jpgfDraw.getStartDirType();
        switch (n) {
            case 0: {
                this.cwd.setSelected(true);
                this.directory.setEnabled(false);
                this.browse.setEnabled(false);
                break;
            }
            case 1: {
                this.lastDir.setSelected(true);
                this.directory.setEnabled(false);
                this.browse.setEnabled(false);
                break;
            }
            case 2: {
                this.named.setSelected(true);
                this.directory.setText(jpgfDraw.getStartDirectory());
                this.directory.setEnabled(true);
                this.browse.setEnabled(true);
                break;
            }
            default: {
                JDRResources.internalError((Component)this, JDRResources.getString("internal_error.invalid_startdir") + ": " + n);
            }
        }
    }

    public void okay(JpgfDraw jpgfDraw) {
        int n = this.cwd.isSelected() ? 0 : (this.lastDir.isSelected() ? 1 : 2);
        jpgfDraw.setStartDirectory(n, this.directory.getText());
    }
}

