/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import uk.ac.uea.cmp.nlct.jdr.DashPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.DashPatternPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class DashPatternSelector
extends JDRSelector {
    private DashPatternPanel dashpatternPanel;

    public DashPatternSelector(JpgfDraw jpgfDraw) {
        super(jpgfDraw, JDRResources.getString("dashpattern.title"), true);
        Dimension dimension = this.getSize();
        dimension.height = 220;
        this.setSize(dimension);
        JpgfDraw.enableHelpOnButton(this.help, "sec:dashpattern");
        this.dashpatternPanel = new DashPatternPanel(this);
        this.dashpatternPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setToMain(this.dashpatternPanel);
    }

    @Override
    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        this.setStroke((JDRBasicStroke)jDRFrame.getSelectedStroke().clone());
        super.initialise();
    }

    @Override
    public void okay() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        jDRFrame.setSelectedDashPattern(this.getDashPattern());
        super.okay();
    }

    public DashPattern getDashPattern() {
        if (this.dashpatternPanel == null) {
            return null;
        }
        return this.dashpatternPanel.getDashPattern();
    }

    public void setStroke(JDRBasicStroke jDRBasicStroke) {
        this.dashpatternPanel.setStroke(jDRBasicStroke);
    }

    @Override
    public JDRBasicStroke getStroke() {
        JDRBasicStroke jDRBasicStroke;
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        if (jDRFrame == null) {
            jDRBasicStroke = new JDRBasicStroke();
        } else {
            jDRBasicStroke = (JDRBasicStroke)jDRFrame.getSelectedStroke().clone();
            if (jDRBasicStroke == null) {
                jDRBasicStroke = new JDRBasicStroke();
            }
        }
        jDRBasicStroke.dashPattern = this.getDashPattern();
        return jDRBasicStroke;
    }

    @Override
    public void setDefaults() {
        this.dashpatternPanel.setDefaults();
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = "DashPatternSelector:" + string;
        return string2 + super.info();
    }
}

