/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import uk.ac.uea.cmp.nlct.jdr.DashPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.DashPatternBox;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class DashPatternPanel
extends JPanel
implements ActionListener {
    private DashPatternBox dashPatternBox;
    private JRadioButton solidLine;
    private JRadioButton dashedLine;
    private JDRSelector selector_;

    public DashPatternPanel(JDRSelector jDRSelector) {
        this.selector_ = jDRSelector;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.solidLine = new JRadioButton(JDRResources.getString("linestyle.solid") + " ");
        this.solidLine.setMnemonic(JDRResources.getChar("linestyle.solid.mnemonic"));
        this.solidLine.addActionListener(this);
        buttonGroup.add(this.solidLine);
        this.add((Component)this.solidLine, gridBagConstraints);
        this.dashedLine = new JRadioButton(JDRResources.getString("linestyle.dashed") + " ");
        this.dashedLine.setMnemonic(JDRResources.getChar("linestyle.dashed.mnemonic"));
        this.dashedLine.addActionListener(this);
        buttonGroup.add(this.dashedLine);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.dashedLine, gridBagConstraints);
        this.dashPatternBox = new DashPatternBox(this.selector_.getSamplePathPanel());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.dashPatternBox, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.dashedLine) {
            this.dashPatternBox.setEnabled(true);
        } else if (object == this.solidLine) {
            this.dashPatternBox.setEnabled(false);
        }
        this.selector_.repaintSample();
    }

    public void setStroke(JDRBasicStroke jDRBasicStroke) {
        this.setDashPattern(jDRBasicStroke.dashPattern);
    }

    public DashPattern getDashPattern() {
        if (this.solidLine.isSelected()) {
            return new DashPattern(null);
        }
        return this.dashPatternBox.getValue();
    }

    public void setDashPattern(DashPattern dashPattern) {
        if (dashPattern.pattern == null) {
            this.solidLine.setSelected(true);
            this.dashPatternBox.setEnabled(false);
        } else {
            this.dashedLine.setSelected(true);
            this.dashPatternBox.setEnabled(true);
            this.dashPatternBox.setValue(dashPattern);
        }
    }

    public void setDefaults() {
        this.setDashPattern(new DashPattern(null));
    }
}

