/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdr.DashPattern;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.NonNegativeLengthPanel;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.SamplePanel;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.TextFieldSampleListener;

class DashPatternBox
extends JPanel
implements ActionListener {
    private NonNegativeLengthPanel dashPanel;
    private NonNegativeLengthPanel gapPanel;
    private NonNegativeLengthPanel offsetPanel;
    private NonNegativeLengthPanel dash2Panel;
    private NonNegativeLengthPanel gap2Panel;
    private JCheckBox secondary;
    private SamplePanel samplePanel;

    public DashPatternBox(SamplePanel samplePanel) {
        this.samplePanel = samplePanel;
        this.setLayout(new GridLayout(2, 3));
        this.offsetPanel = new NonNegativeLengthPanel(JDRResources.getString("dash.offset") + " ");
        this.offsetPanel.getDocument().addDocumentListener(new TextFieldSampleListener(samplePanel));
        this.offsetPanel.getTextField().setColumns(2);
        this.add(this.offsetPanel);
        this.dashPanel = new NonNegativeLengthPanel(JDRResources.getString("dash.label") + " ");
        this.dashPanel.getDocument().addDocumentListener(new TextFieldSampleListener(samplePanel));
        this.dashPanel.getTextField().setColumns(2);
        this.dashPanel.setValue(10.0);
        this.add(this.dashPanel);
        this.gapPanel = new NonNegativeLengthPanel(JDRResources.getString("dash.gap") + " ");
        this.gapPanel.getDocument().addDocumentListener(new TextFieldSampleListener(samplePanel));
        this.gapPanel.getTextField().setColumns(2);
        this.gapPanel.setValue(5.0);
        this.add(this.gapPanel);
        this.secondary = new JCheckBox(JDRResources.getString("dash.secondary") + " ");
        this.secondary.addActionListener(this);
        this.add(this.secondary);
        this.dash2Panel = new NonNegativeLengthPanel(JDRResources.getString("dash.label") + " ");
        this.dash2Panel.getDocument().addDocumentListener(new TextFieldSampleListener(samplePanel));
        this.dash2Panel.getTextField().setColumns(2);
        this.dash2Panel.setValue(1.0);
        this.add(this.dash2Panel);
        this.gap2Panel = new NonNegativeLengthPanel(JDRResources.getString("dash.gap") + " ");
        this.gap2Panel.getDocument().addDocumentListener(new TextFieldSampleListener(samplePanel));
        this.gap2Panel.getTextField().setColumns(2);
        this.gap2Panel.setValue(5.0);
        this.add(this.gap2Panel);
        this.setSecondaryDash(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.secondary) {
            this.enableSecondaryDash(this.secondary.isSelected());
            this.samplePanel.updateSamples();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.dashPanel.setEnabled(bl);
        this.gapPanel.setEnabled(bl);
        this.offsetPanel.setEnabled(bl);
        this.secondary.setEnabled(bl);
        if (!bl) {
            this.secondary.setSelected(false);
            this.enableSecondaryDash(false);
        } else {
            this.dashPanel.getTextField().requestFocusInWindow();
        }
    }

    public DashPattern getValue() {
        float f = (float)this.dashPanel.getValue();
        float f2 = (float)this.gapPanel.getValue();
        if (f == 0.0f && f2 == 0.0f) {
            f = 1.0f;
        }
        if (this.secondary.isSelected()) {
            float f3 = (float)this.dash2Panel.getValue();
            float f4 = (float)this.gap2Panel.getValue();
            if (f3 == 0.0f && f4 == 0.0f) {
                f3 = 1.0f;
            }
            return new DashPattern(new float[]{f, f2, f3, f4}, (float)this.offsetPanel.getValue());
        }
        return new DashPattern(new float[]{f, f2}, (float)this.offsetPanel.getValue());
    }

    public void setValue(DashPattern dashPattern) {
        this.setSecondaryDash(false);
        if (dashPattern.pattern == null) {
            this.dashPanel.setValue(1.0);
            this.gapPanel.setValue(0.0);
        } else if (dashPattern.pattern.length == 1) {
            this.dashPanel.setValue(dashPattern.pattern[0]);
            this.gapPanel.setValue(0.0);
        } else {
            this.dashPanel.setValue(dashPattern.pattern[0]);
            this.gapPanel.setValue(dashPattern.pattern[1]);
            if (dashPattern.pattern.length >= 4) {
                this.dash2Panel.setValue(dashPattern.pattern[2]);
                this.gap2Panel.setValue(dashPattern.pattern[3]);
                this.setSecondaryDash(true);
            }
        }
        this.offsetPanel.setValue(dashPattern.offset);
    }

    public void setSecondaryDash(boolean bl) {
        this.secondary.setSelected(bl);
        this.enableSecondaryDash(bl);
    }

    public void enableSecondaryDash(boolean bl) {
        this.dash2Panel.setEnabled(bl);
        this.gap2Panel.setEnabled(bl);
    }
}

