/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;

class ControlPaintPanel
extends JPanel
implements ActionListener {
    private JDRPoint point;
    private Paint paint;
    private double pointSize;
    private JPanel samplePanel;
    private JButton selectButton;
    private JColorChooser colorChooser;
    private JDialog colorDialog;
    private Dimension samplePanelSize;
    private JLabel label;

    public ControlPaintPanel(JDRPoint jDRPoint, String string) {
        this(jDRPoint, string, 10.0);
    }

    public ControlPaintPanel(JDRPoint jDRPoint, String string, double d) {
        this.point = jDRPoint;
        this.pointSize = d;
        this.point.y = this.point.x = this.pointSize * 0.5 + 1.0;
        this.label = new JLabel(this.point.isSelected() ? JDRResources.getString("render.control.selected") : JDRResources.getString("render.control.unselected"));
        this.paint = this.point.isSelected() ? this.point.getSelectedPaint() : this.point.getUnselectedPaint();
        this.samplePanelSize = new Dimension((int)this.pointSize + 2, (int)this.pointSize + 2);
        this.samplePanel = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                ControlPaintPanel.this.point.draw(graphics, 1.0, ControlPaintPanel.this.paint, ControlPaintPanel.this.pointSize);
            }

            @Override
            public Color getBackground() {
                return Color.white;
            }

            @Override
            public Dimension getPreferredSize() {
                return ControlPaintPanel.this.samplePanelSize;
            }

            @Override
            public Dimension getMinimumSize() {
                return ControlPaintPanel.this.samplePanelSize;
            }
        };
        this.add(this.samplePanel);
        this.add(this.label);
        this.selectButton = new JButton(JDRResources.getString("label.select"));
        this.selectButton.addActionListener(this);
        this.add(this.selectButton);
        this.colorChooser = new JColorChooser((Color)this.paint);
        this.colorChooser.setPreviewPanel(new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                ControlPaintPanel.this.point.draw(graphics, 1.0, ControlPaintPanel.this.colorChooser.getColor(), ControlPaintPanel.this.pointSize);
            }

            @Override
            public Color getBackground() {
                return Color.white;
            }

            @Override
            public Dimension getPreferredSize() {
                return ControlPaintPanel.this.samplePanelSize;
            }

            @Override
            public Dimension getMinimumSize() {
                return ControlPaintPanel.this.samplePanelSize;
            }
        });
        this.colorDialog = JColorChooser.createDialog(this, string, true, this.colorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPaintPanel.this.paint = ControlPaintPanel.this.colorChooser.getColor();
                ControlPaintPanel.this.samplePanel.repaint();
            }
        }, null);
    }

    public void updatePaint() {
        if (this.point.isSelected()) {
            this.point.setSelectedPaint(this.paint);
        } else {
            this.point.setUnselectedPaint(this.paint);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.selectButton) {
            this.colorDialog.setVisible(true);
        }
    }

    public JLabel getLabel() {
        return this.label;
    }

    public String getLabelText() {
        return this.label.getText();
    }
}

