/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.PercentageField;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.TextFieldSBarListener;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.SingleColourSelector;

public class ColorRGBPanel
extends JPanel
implements AdjustmentListener,
SingleColourSelector {
    private JScrollBar redSB;
    private JScrollBar greenSB;
    private JScrollBar blueSB;
    private JScrollBar alphaSB;
    private PercentageField redText;
    private PercentageField greenText;
    private PercentageField blueText;
    private PercentageField alphaText;
    private JLabel redLabel;
    private JLabel greenLabel;
    private JLabel blueLabel;
    private JLabel alphaLabel;

    public ColorRGBPanel() {
        this.initialise();
    }

    public ColorRGBPanel(AdjustmentListener adjustmentListener) {
        this.initialise();
        this.addAdjustmentListener(adjustmentListener);
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.redSB.addAdjustmentListener(adjustmentListener);
        this.greenSB.addAdjustmentListener(adjustmentListener);
        this.blueSB.addAdjustmentListener(adjustmentListener);
        this.alphaSB.addAdjustmentListener(adjustmentListener);
    }

    public void initialise() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, gridBagConstraints);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 100.0;
        gridBagConstraints2.weighty = 100.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        this.redLabel = new JLabel(JDRResources.getString("colour.red"), 4);
        jPanel.add((Component)this.redLabel, gridBagConstraints2);
        this.redSB = new JScrollBar(0, 0, 0, 0, 100);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.gridheight = 1;
        jPanel.add((Component)this.redSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        this.redText = new PercentageField(0);
        jPanel.add((Component)this.redText, gridBagConstraints2);
        this.redText.getDocument().addDocumentListener(new TextFieldSBarListener(this.redText, this.redSB));
        this.redSB.setBlockIncrement(10);
        this.redSB.addAdjustmentListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 1;
        this.greenLabel = new JLabel(JDRResources.getString("colour.green"), 4);
        jPanel.add((Component)this.greenLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 3;
        this.greenSB = new JScrollBar(0, 0, 0, 0, 100);
        jPanel.add((Component)this.greenSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        this.greenText = new PercentageField(0);
        jPanel.add((Component)this.greenText, gridBagConstraints2);
        this.greenText.getDocument().addDocumentListener(new TextFieldSBarListener(this.greenText, this.greenSB));
        this.greenSB.setBlockIncrement(10);
        this.greenSB.addAdjustmentListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        this.blueLabel = new JLabel(JDRResources.getString("colour.blue"), 4);
        jPanel.add((Component)this.blueLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 4;
        this.blueSB = new JScrollBar(0, 0, 0, 0, 100);
        jPanel.add((Component)this.blueSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        this.blueText = new PercentageField(0);
        jPanel.add((Component)this.blueText, gridBagConstraints2);
        this.blueText.getDocument().addDocumentListener(new TextFieldSBarListener(this.blueText, this.blueSB));
        this.blueSB.setBlockIncrement(10);
        this.blueSB.addAdjustmentListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 1;
        this.alphaLabel = new JLabel(JDRResources.getString("colour.alpha"), 4);
        jPanel.add((Component)this.alphaLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 4;
        this.alphaSB = new JScrollBar(0, 100, 0, 0, 100);
        jPanel.add((Component)this.alphaSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        this.alphaText = new PercentageField(100);
        jPanel.add((Component)this.alphaText, gridBagConstraints2);
        this.alphaText.getDocument().addDocumentListener(new TextFieldSBarListener(this.alphaText, this.alphaSB));
        this.alphaSB.setBlockIncrement(10);
        this.alphaSB.addAdjustmentListener(this);
    }

    @Override
    public boolean requestDefaultColourFocus() {
        return this.redText.requestFocusInWindow();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.redText.getValue() != this.redSB.getValue()) {
            this.redText.setValue(this.redSB.getValue());
        }
        if (this.greenText.getValue() != this.greenSB.getValue()) {
            this.greenText.setValue(this.greenSB.getValue());
        }
        if (this.blueText.getValue() != this.blueSB.getValue()) {
            this.blueText.setValue(this.blueSB.getValue());
        }
        if (this.alphaText.getValue() != this.alphaSB.getValue()) {
            this.alphaText.setValue(this.alphaSB.getValue());
        }
    }

    @Override
    public JDRPaint getPaint() {
        JDRColor jDRColor = null;
        try {
            jDRColor = new JDRColor((float)this.redSB.getValue() / 100.0f, (float)this.greenSB.getValue() / 100.0f, (float)this.blueSB.getValue() / 100.0f, (float)this.alphaSB.getValue() / 100.0f);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return jDRColor;
    }

    @Override
    public void setPaint(JDRPaint jDRPaint) {
        JDRColor jDRColor = jDRPaint.getJDRColor();
        this.redSB.setValue((int)Math.round(jDRColor.getRed() * 100.0));
        this.greenSB.setValue((int)Math.round(jDRColor.getGreen() * 100.0));
        this.blueSB.setValue((int)Math.round(jDRColor.getBlue() * 100.0));
        this.alphaSB.setValue((int)Math.round(jDRColor.getAlpha() * 100.0));
    }

    @Override
    public void setEnabled(boolean bl) {
        this.redSB.setEnabled(bl);
        this.greenSB.setEnabled(bl);
        this.blueSB.setEnabled(bl);
        this.alphaSB.setEnabled(bl);
        this.redText.setEnabled(bl);
        this.greenText.setEnabled(bl);
        this.blueText.setEnabled(bl);
        this.alphaText.setEnabled(bl);
        this.redLabel.setEnabled(bl);
        this.greenLabel.setEnabled(bl);
        this.blueLabel.setEnabled(bl);
        this.alphaLabel.setEnabled(bl);
    }
}

